/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.util;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.seasar.framework.exception.SQLRuntimeException;

public class ConnectionUtil {
    protected ConnectionUtil() {
    }

    public static void close(Connection connection) throws SQLRuntimeException {
        if (connection == null) {
            return;
        }
        try {
            connection.close();
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    public static Statement createStatement(Connection connection) throws SQLRuntimeException {
        try {
            return connection.createStatement();
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    public static PreparedStatement prepareStatement(Connection connection, String sql) throws SQLRuntimeException {
        try {
            return connection.prepareStatement(sql);
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    public static PreparedStatement prepareStatement(Connection connection, String sql, int autoGeneratedKeys) throws SQLRuntimeException {
        try {
            return connection.prepareStatement(sql, autoGeneratedKeys);
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    public static PreparedStatement prepareStatement(Connection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLRuntimeException {
        try {
            return connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    public static CallableStatement prepareCall(Connection connection, String sql) throws SQLRuntimeException {
        try {
            return connection.prepareCall(sql);
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    public static DatabaseMetaData getMetaData(Connection connection) throws SQLRuntimeException {
        try {
            return connection.getMetaData();
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }
}

