#include "renamesingledialog.h"
#include "ui_renamesingledialog.h"
#include <QMessageBox>

///////////////////////////////////////////////////////////////////////////////
/// \brief RenameSingleDialog::RenameSingleDialog
/// \param parent   親ウィジェット
///
/// コンストラクタ
///
RenameSingleDialog::RenameSingleDialog(QWidget *parent) :
    AbstractRenameDialog(parent),
    ui(new Ui::RenameSingleDialog)
{
    ui->setupUi(this);

    ui->nameAfter->setFocus();
}

///////////////////////////////////////////////////////////////////////////////
/// \brief RenameSingleDialog::~RenameSingleDialog
///
/// デストラクタ
///
RenameSingleDialog::~RenameSingleDialog()
{
    delete ui;
}

///////////////////////////////////////////////////////////////////////////////
/// \brief RenameSingleDialog::setNames
/// \param names    ファイルインフォリスト
///
/// 変更前後の名前を設定します。
///
void RenameSingleDialog::setNames(const QFileInfoList &names)
{
    ui->nameBefore->setText(names[0].fileName());
    ui->nameAfter->setText(names[0].fileName());
}

///////////////////////////////////////////////////////////////////////////////
/// \brief RenameSingleDialog::on_btn_UpperAll_clicked
///
/// ファイル名全体を大文字にします。
///
void RenameSingleDialog::on_btn_UpperAll_clicked()
{
    ui->nameAfter->setText(ui->nameAfter->text().toUpper());
}

///////////////////////////////////////////////////////////////////////////////
/// \brief RenameSingleDialog::on_btn_LowerAll_clicked
///
/// ファイル名全体を小文字にします。
///
void RenameSingleDialog::on_btn_LowerAll_clicked()
{
    ui->nameAfter->setText(ui->nameAfter->text().toLower());
}

///////////////////////////////////////////////////////////////////////////////
/// \brief RenameSingleDialog::on_btn_UpperExt_clicked
///
/// 拡張子を大文字にします。
///
void RenameSingleDialog::on_btn_UpperExt_clicked()
{
    QFileInfo info(m_dir.absoluteFilePath(ui->nameAfter->text()));
    ui->nameAfter->setText(info.completeBaseName() + "." + info.suffix().toUpper());
}

///////////////////////////////////////////////////////////////////////////////
/// \brief RenameSingleDialog::on_btn_LowerExt_clicked
///
/// 拡張子を小文字にします。
///
void RenameSingleDialog::on_btn_LowerExt_clicked()
{
    QFileInfo info(m_dir.absoluteFilePath(ui->nameAfter->text()));
    ui->nameAfter->setText(info.completeBaseName() + "." + info.suffix().toLower());
}

///////////////////////////////////////////////////////////////////////////////
/// \brief RenameSingleDialog::accept
///
/// OKボタンクリック時の処理を行います。
///
void RenameSingleDialog::accept()
{
    if (ui->nameAfter->text() != ui->nameBefore->text()) {
        m_RenameMap.insert(m_dir.absoluteFilePath(ui->nameBefore->text()),
                           m_dir.absoluteFilePath(ui->nameAfter->text()));
    }

    AbstractRenameDialog::accept();
}
