#ifndef PREFERENCES_H
#define PREFERENCES_H

#include <QMainWindow>
#include <QSettings>
class FolderModel;

#define DECLARE_BOOL(key)           \
    bool    is##key() const;        \
    bool    def##key() const;       \
    void    set##key(bool value)

#define DECLARE_OBJECT(Type, key)       \
    Type    get##key() const;           \
    Type    def##key() const;           \
    void    set##key(const Type &value)

#define DECLARE_PRIMITIVE(Type, key)    \
    Type    get##key() const;           \
    Type    def##key() const;           \
    void    set##key(Type value)

class Preferences : public QSettings
{
    Q_OBJECT
public:
    explicit Preferences(QObject *parent = 0);
    Preferences(const QString &path, QObject *parent = 0);

    void    restoreModel(const QString &side, FolderModel *m);
    void    saveModel(const QString &side, const FolderModel *m);

    void    restoreWindow(QMainWindow *w);
    void    saveWindow(const QMainWindow *w);

    void    addBookmark(const QString &name, const QString &path);
    void    clearBookmark();
    QString getBookmarkEntry(int n) const;
    QString getBookmarkPath(int n) const;

    QColor folderViewFgColor(bool active) const;
    QColor folderViewBgColor(bool active) const;
    QColor folderViewMarkedFgColor(bool active) const;
    QColor folderViewMarkedBgColor(bool active) const;
    QColor folderViewSystemColor(bool active) const;
    QColor folderViewHiddenColor(bool active) const;
    QColor folderViewReadOnlyColor(bool active) const;
    QColor locationBoxFgColor(bool active) const;
    QColor locationBoxBgColor(bool active) const;

    DECLARE_BOOL(Reset);
    DECLARE_BOOL(CheckUpdate);
    DECLARE_BOOL(ConfirmQuit);
    DECLARE_BOOL(ConfirmCopy);
    DECLARE_BOOL(AutoCloseCopy);
    DECLARE_BOOL(ConfirmMove);
    DECLARE_BOOL(AutoCloseMove);
    DECLARE_BOOL(ConfirmDelete);
    DECLARE_BOOL(AutoCloseDelete);
    DECLARE_BOOL(ConfirmRename);
    DECLARE_BOOL(AutoCloseRename);
    DECLARE_BOOL(OpenAfterCreation);
    DECLARE_BOOL(MoveAfterCreation);

    DECLARE_OBJECT(QString, ArchiverPath);
    DECLARE_OBJECT(QString, EditorPath);
    DECLARE_OBJECT(QString, TerminalPath);
    DECLARE_OBJECT(QString, CopyBehavior);
    DECLARE_OBJECT(QString, PreferExtensions);

    DECLARE_OBJECT(QColor, FolderViewFgColor);
    DECLARE_OBJECT(QColor, FolderViewBgColor);
    DECLARE_OBJECT(QColor, FolderViewMarkedFgColor);
    DECLARE_OBJECT(QColor, FolderViewMarkedBgColor);
    DECLARE_OBJECT(QColor, FolderViewSystemColor);
    DECLARE_OBJECT(QColor, FolderViewHiddenColor);
    DECLARE_OBJECT(QColor, FolderViewReadOnlyColor);
    DECLARE_OBJECT(QColor, LocationBoxFgColor);
    DECLARE_OBJECT(QColor, LocationBoxBgColor);
    DECLARE_OBJECT(QColor, SearchBoxFgColor);
    DECLARE_OBJECT(QColor, SearchBoxBgColor);
    DECLARE_OBJECT(QColor, SearchBoxUnmatchFgColor);
    DECLARE_OBJECT(QColor, SearchBoxUnmatchBgColor);
    DECLARE_OBJECT(QColor, TextViewFgColor);
    DECLARE_OBJECT(QColor, TextViewCtrlColor);
    DECLARE_OBJECT(QColor, TextViewBgColor);
    DECLARE_OBJECT(QColor, HexViewFgColor);
    DECLARE_OBJECT(QColor, HexViewBgColor);
    DECLARE_OBJECT(QColor, ImageViewBgColor);

    DECLARE_PRIMITIVE(double, DarkFacotr);
    DECLARE_PRIMITIVE(double, LineHeight);
    DECLARE_PRIMITIVE(double, TextViewLineHeight);

    DECLARE_OBJECT(QFont, FolderViewFont);
    DECLARE_OBJECT(QFont, LocationBoxFont);
    DECLARE_OBJECT(QFont, SearchBoxFont);
    DECLARE_OBJECT(QFont, TextViewFont);
    DECLARE_OBJECT(QFont, HexViewFont);

signals:

public slots:

};

#endif // PREFERENCES_H
