#ifndef OPERATIONDIALOG_H
#define OPERATIONDIALOG_H

#include <QDialog>
class OperationWorker;

namespace Ui {
class OperationDialog;
}

class OperationDialog : public QDialog
{
    Q_OBJECT

public:
    explicit OperationDialog(QWidget *parent = 0);
    ~OperationDialog();

    void setWorker(OperationWorker *worker) {
        m_worker = worker;
    }
    void setAutoClose(bool yes);
    bool autoClose() const;

private:
    Ui::OperationDialog *ui;

    OperationWorker*    m_worker;
    bool                m_Error;

private slots:
    void onProgress(const QString &msg);
    void onSuccess(const QString &msg);
    void onError(const QString &msg);
    void onFinished(bool abort);
    void on_btnCloseCancel_clicked();
    void on_btnShowDetail_clicked();

    // QDialog interface
public slots:
    int exec();
};

#endif // OPERATIONDIALOG_H
