#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "overwritedialog.h"

#include <QFileInfo>
#include <QModelIndex>
#include <QNetworkReply>
#include <QAbstractItemView>
#include <QMainWindow>
class FolderView;
class FolderModel;
class Panel;

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

signals:

private slots:
    void    app_focusChange(QWidget *old, QWidget *now);
    void    checkUpdateFinished(QNetworkReply *reply, bool silent = false);
    void    checkUpdateFinishedSilent(QNetworkReply *reply);
    void    model_PreReset();
    void    model_PostReset();
    void    onAbout();
    void    onCheckUpdate(bool silent = false);
    void    onChooseFolder();
    void    onCopy();
    void    onCopyFileName();
    void    onCopyFilePath();
    void    onCreateFile();
    void    onCreateFolder();
    void    onDelete();
    void    onEditBookmark();
    void    onExpandLeft();
    void    onExpandRight();
    void    onKeyDown();
    void    onKeyDownOther();
    void    onKeyEnd();
    void    onKeyEndOther();
    void    onKeyHome();
    void    onKeyHomeOther();
    void    onKeyLeft();
    void    onKeyRight();
    void    onKeyUp();
    void    onKeyUpOther();
    void    onMove();
    void    onOpenArchiver();
    void    onOpenBookmark();
    void    onOpenEditor(const QModelIndex &index = QModelIndex());
    void    onOpenTerminal();
    void    onOpenWith();
    void    onRename();
    void    onRunCommand();
    void    onSearchNext();
    void    onSearchPrev();
    void    onSplitCenter();
    void    onSwap();
    void    onSyncPanel();
    void    onSyncPanelTo();
    void    onToggleFullMode(bool checked);
    void    onToggleHidden(bool checked);
    void    onToggleMark();
    void    onTogglePreviewMode(bool checked);
    void    onToggleSearch(bool checked);
    void    onToggleSystem(bool checked);
    void    onToggleThumbnailMode(bool checked);
    void    onToggleToolbar(bool checked);
    void    showBookmarkDialog();
    void    showFilterDialog();
    void    showHistoryDialog();
    void    showPreferenceDialog();
    void    showSortDialog();

public slots:
    void    askOverWrite(QString *copyMethod, QString *alias,
                          const QString &srcPath, const QString &tgtPath);
    void    copyItems(const QStringList &list, const QString &tgtDir);
    void    moveItems(const QStringList &list, const QString &tgtDir);
    void    onAddBookmark();
    void    onOpen(const QModelIndex &index = QModelIndex());
    void    prefs_updated();
    void    view_copyAvailable(bool yes);
    void    view_currentChanged(const QModelIndex & current, const QModelIndex & previous);
    void    view_finished();
    void    view_statusChanged(const QString &text = QString());
    void    view_showed(QWidget* w);

private:
    typedef QList<QAction*> ActionList;
    enum Mode {
        ModeBasic = 1,  // 二画面モード
        ModeFull,       // 単画面モード
        ModeView,       // ビューモード
        ModePreview,    // プレビューモード
    };
    Ui::MainWindow *ui;
    OverWriteDialog m_overwriteDialog;
    Mode m_viewMode;
    Mode m_prevMode;
    ActionList m_actions;

    FolderModel*        activeModel() const;
    Panel*              activePanel() const;
    QAbstractItemView*  focusItemView() const;
    FolderModel*        inactiveModel() const;
    Panel*              inactivePanel() const;
    void                initActions();
    void                initBookmarkMenu();
    bool                onContextMenuEvent(QObject *obj, QContextMenuEvent *e);
    bool                onKeyPressEvent(QObject *obj, QKeyEvent *e);
    QFileInfoList       selectedItems() const;
    void                sendEventOther(QEvent *event);
    void                setActiveModel(FolderModel *m);
    void                setEnabledAllActions(bool enable);
    void                setViewMode(Mode mode);
    bool                startProcess(const QString &cmd, const QString &errMsg);
    void                updateActions();

    // QWidget interface
protected:
    void closeEvent(QCloseEvent *event);

    // QObject interface
public:
    bool eventFilter(QObject *watched, QEvent *e);
};

#endif // MAINWINDOW_H
