#include "foldermodel.h"
#include "historydialog.h"
#include "ui_historydialog.h"

///////////////////////////////////////////////////////////////////////////////
/// \brief HistoryDialog::HistoryDialog
/// \param parent   親ウィジェット
///
/// コンストラクタ
///
HistoryDialog::HistoryDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::HistoryDialog),
    m_leftModel(NULL),
    m_rightModel(NULL),
    m_activeModel(NULL)
{
    ui->setupUi(this);
    resize(parent->width() * 0.8, height());

    connect(ui->listLeft, SIGNAL(doubleClicked(QModelIndex)), this, SLOT(accept()));
    connect(ui->listRight, SIGNAL(doubleClicked(QModelIndex)), this, SLOT(accept()));
}

///////////////////////////////////////////////////////////////////////////////
/// \brief HistoryDialog::~HistoryDialog
///
/// デストラクタ
///
HistoryDialog::~HistoryDialog()
{
    delete ui;
}

///////////////////////////////////////////////////////////////////////////////
/// \brief HistoryDialog::setModel
/// \param left     左パネルのモデル
/// \param right    右パネルのモデル
/// \param active   アクティブモデル
///
/// モデルを設定します。
///
void HistoryDialog::setModel(const FolderModel *left, const FolderModel *right, FolderModel *active)
{
    m_leftModel = left;
    m_rightModel = right;
    m_activeModel = active;

    if (active == left) {
        ui->radioLeft->click();
    }
    else {
        ui->radioRight->click();
    }

    for (int n = left->history().size() - 1; n >= 0; --n) {
        ui->listLeft->addItem(left->history().at(n));
    }
    for (int n = right->history().size() - 1; n >= 0; --n) {
        ui->listRight->addItem(right->history().at(n));
    }
}

///////////////////////////////////////////////////////////////////////////////
/// \brief HistoryDialog::on_radioLeft_clicked
///
/// 左パネルラジオボタンクリック時の処理を行います。
///
void HistoryDialog::on_radioLeft_clicked()
{
    ui->listRight->setVisible(false);
    ui->listLeft->setVisible(true);
}

///////////////////////////////////////////////////////////////////////////////
/// \brief HistoryDialog::on_radioRight_clicked
///
/// 右パネルラジオボタンクリック時の処理を行います。
///
void HistoryDialog::on_radioRight_clicked()
{
    ui->listLeft->setVisible(false);
    ui->listRight->setVisible(true);
}

///////////////////////////////////////////////////////////////////////////////
/// \brief HistoryDialog::accept
///
/// OKボタンクリック時の処理を行います。
///
void HistoryDialog::accept()
{
    QString path;
    const FolderModel *selected;
    if (ui->radioLeft->isChecked()) {
        selected = m_leftModel;
        path = ui->listLeft->currentItem()->text();
    }
    else {
        selected = m_rightModel;
        path = ui->listRight->currentItem()->text();
    }

    if (selected == m_activeModel) {
        m_activeModel->setHistoryAt(path);
    }
    else {
        m_activeModel->setRootPath(path);
    }

    QDialog::accept();
}
