#ifndef HEXVIEW_H
#define HEXVIEW_H

#include <QWidget>
class QScrollArea;

class HexView : public QWidget
{
    Q_OBJECT
public:
    explicit HexView(QScrollArea *parent = 0);

    void    setData(const QByteArray &data);

private:
    QScrollArea*    m_scrollArea;
    QByteArray      m_data;
    int             m_charHeight;
    int             m_charWidth;
    int             m_selectionBegin;
    int             m_selectionEnd;
    int             m_selectionInit;

    int     addressChars() const;
    void    adjust();
    int     cursorPos(const QPoint &pos);
    void    resetSelection(int index);
    void    setSelection(int index);
    int     xPosHex() const;
    int     xPosAscii() const;


signals:
    void    copyAvailable(bool);
    void    statusChanged(const QString &text);

public slots:
    void    onCopy();
    void    onScaleDown();
    void    onScaleUp();
    void    onSelectAll();

    // QWidget interface
public slots:
    void setVisible(bool visible);

protected:
    void mousePressEvent(QMouseEvent *e);
    void mouseDoubleClickEvent(QMouseEvent *e);
    void mouseMoveEvent(QMouseEvent *e);
    void paintEvent(QPaintEvent *e);
};

#endif // HEXVIEW_H
