#ifndef FOLDERVIEW_PRIVATE_H
#define FOLDERVIEW_PRIVATE_H

#include <QObject>
#include <QAbstractItemView>

class FolderView_Private : public QObject
{
    Q_OBJECT
public:
    explicit FolderView_Private(QAbstractItemView *parent = 0);

private:
    QAbstractItemView*  m_view;
    QPoint              m_dragStartPos;
    bool                m_dragging;
    int                 m_saveRow;
    QString             m_savePath;
    QString             m_saveName;

    bool    onDragEnter(QObject *obj, QDragEnterEvent *e);
    bool    onDrop(QObject *obj, QDropEvent *e);
    bool    onMouseMove(QObject *obj, QMouseEvent *e);
    bool    onMousePress(QObject *obj, QMouseEvent *e);

signals:
    void    copyItems(const QStringList &list, const QString &tgtDir);
    void    moveItems(const QStringList &list, const QString &tgtDir);

public slots:
    void    model_PostReset();
    void    model_PreReset();

    // QObject interface
public:
    bool eventFilter(QObject *obj, QEvent *e);
};

#endif // FOLDERVIEW_PRIVATE_H
