#ifndef FOLDERPANEL_H
#define FOLDERPANEL_H

#include <QWidget>
#include <QAbstractItemView>
class FolderModel;
class MainWindow;
class Preferences;

namespace Ui {
class FolderPanel;
}

class FolderPanel : public QWidget
{
    Q_OBJECT

public:
    explicit FolderPanel(QWidget *parent = 0);
    ~FolderPanel();

    void                initialize(MainWindow *w);
    QAbstractItemView*  itemView() const;
    FolderModel*        model() const;
    void                searchNext(int step = 1);
    void                setItemView(const QString &name);
    void                setModel(FolderModel *m);
    void                toggleSearch(bool checked);
    void                toggleView(bool checked);
    void                updateAppearance(const Preferences &prefs);

private:
    Ui::FolderPanel *ui;
    MainWindow *m_mainWnd;

    void    showSearchResult(const QModelIndex &index);

public slots:

private slots:
    void    model_dataChanged(const QModelIndex & topLeft, const QModelIndex & bottomRight);
    void    model_Reset();
    void    on_searchBox_textEdited(const QString &arg1);
};

#endif // FOLDERPANEL_H
