#ifndef DELETEWORKER_H
#define DELETEWORKER_H

#include "operationworker.h"

#include <QFileInfoList>
#include <QStringList>

class DeleteWorker : public OperationWorker
{
    Q_OBJECT
public:
    explicit DeleteWorker();

    void setDeleteList(const QFileInfoList &list) {
        m_DeleteList = list;
    }

private:
    QFileInfoList   m_DeleteList;
    QStringList     m_Targets;

    void Listup(const QString &path);

    // AbstractWorker interface
public slots:
    void run();

    // OperationWorker interface
public:
    QString initialText() const;
};

#endif // DELETEWORKER_H
