#include "deleteworker.h"

#include <QFileInfo>
#include <QDir>
#include <QDebug>
#include <QThread>

const int SLEEP_TIME = 1;

///////////////////////////////////////////////////////////////////////////////
/// \brief DeleteWorker::DeleteWorker
///
/// コンストラクタ
///
DeleteWorker::DeleteWorker() :
    OperationWorker(),
    m_DeleteList(),
    m_Targets()
{
}

///////////////////////////////////////////////////////////////////////////////
/// \brief DeleteWorker::Listup
/// \param path 削除するパス
///
/// 削除対象をリストアップします。(再帰)
///
void DeleteWorker::Listup(const QString &path)
{
    if (isAborted()) {
        return;
    }
    this->thread()->msleep(SLEEP_TIME);

    if (QFileInfo(path).isDir()) {
        QDir dir(path);
        QFileInfoList list = dir.entryInfoList(QDir::NoDotAndDotDot |
                                               QDir::System |
                                               QDir::Hidden |
                                               QDir::AllDirs |
                                               QDir::Files,
                                               QDir::DirsFirst);
        foreach (const QFileInfo &info, list) {
            Listup(info.absoluteFilePath());
        }
    }

    m_Targets << path;
}

///////////////////////////////////////////////////////////////////////////////
/// \brief DeleteWorker::run
///
/// 削除を実行します。
///
void DeleteWorker::run()
{
    foreach (const QFileInfo &info, m_DeleteList) {
        if (isAborted()) {
            emit finished(true);
            return;
        }
        Listup(info.absoluteFilePath());
    }

    bool ret;
    int successCount = 0;
    int errorCount = 0;
    QString msg;
    foreach (const QString &path, m_Targets) {
        this->thread()->msleep(SLEEP_TIME);
        if (isAborted()) {
            emit finished(true);
            return;
        }

        emit progress(tr("削除：%1").arg(path));

        QFileInfo info(path);
        if (info.isDir()) {
            QDir dir(path);
            ret = dir.rmdir(path);
        }
        else {
            ret = QFile::remove(path);
        }

        if (ret) {
            successCount++;
            emit success(tr("成功"));
        }
        else {
            errorCount++;
            emit error(tr("失敗"));
        }

        msg = tr("%1アイテム成功。").arg(successCount);
        if (errorCount > 0) {
            msg += tr("%1アイテム失敗。").arg(errorCount);
        }
        emit information(msg);
    }

    emit finished();
}

///////////////////////////////////////////////////////////////////////////////
/// \brief DeleteWorker::initialText
/// \return 初期表示テキストを返します。
///
QString DeleteWorker::initialText() const
{
    return tr("削除準備中...");
}
