#include "abstractworker.h"

#include <QThread>

///////////////////////////////////////////////////////////////////////////////
/// \brief AbstractWorker::AbstractWorker
///
/// コンストラクタ
///
AbstractWorker::AbstractWorker() :
    QObject(),
    m_mutex(),
    m_abort(false),
    m_thread(new QThread())
{
    connect(m_thread, SIGNAL(started()), this, SLOT(run()));
    connect(this, SIGNAL(finished()), m_thread, SLOT(quit()));
    connect(this, SIGNAL(finished()), this, SLOT(deleteLater()));
    connect(m_thread, SIGNAL(finished()), m_thread, SLOT(deleteLater()));
}

///////////////////////////////////////////////////////////////////////////////
/// \brief AbstractWorker::abort
///
/// 処理を中止します
///
void AbstractWorker::abort()
{
    QMutexLocker lock(&m_mutex);
    m_abort = true;
}

///////////////////////////////////////////////////////////////////////////////
/// \brief AbstractWorker::start
///
/// ワーカースレッドを開始します。
///
void AbstractWorker::start()
{
    this->moveToThread(m_thread);
    m_thread->start();
}

///////////////////////////////////////////////////////////////////////////////
/// \brief AbstractWorker::isAborted
/// \return 中止要求されていればtrueを返します。
///
bool AbstractWorker::isAborted()
{
    QMutexLocker lock(&m_mutex);
    return m_abort;
}

