BEGIN TRANSACTION;
PRAGMA user_version = 82; 
CREATE TABLE _deleted_groups (_sync_version TEXT,_sync_id TEXT,_sync_account TEXT,_sync_mark INTEGER);
CREATE TABLE _deleted_people (_sync_version TEXT,_sync_id TEXT,_sync_account TEXT,_sync_mark INTEGER);
CREATE TABLE _sync_state (_id INTEGER PRIMARY KEY,_sync_account TEXT,data TEXT,UNIQUE(_sync_account));
INSERT INTO _sync_state VALUES(1,'lemmytest@gmail.com','');
CREATE TABLE _sync_state_metadata (version INTEGER);
INSERT INTO _sync_state_metadata VALUES(2);
CREATE TABLE android_metadata (locale TEXT);
INSERT INTO android_metadata VALUES('en_US');
CREATE TABLE calls (_id INTEGER PRIMARY KEY AUTOINCREMENT,number TEXT,date INTEGER,duration INTEGER,type INTEGER,new INTEGER,name TEXT,numbertype INTEGER,numberlabel TEXT);
CREATE TABLE contact_methods (_id INTEGER PRIMARY KEY AUTOINCREMENT,person INTEGER REFERENCES people(_id),kind INTEGER NOT NULL,data TEXT,aux_data TEXT,type INTEGER NOT NULL,label TEXT,isprimary INTEGER NOT NULL DEFAULT 0);
INSERT INTO contact_methods VALUES(1,3,1,'weyj@xtdt.com',NULL,1,NULL,1);
INSERT INTO contact_methods VALUES(2,4,1,'mail@dom.com',NULL,1,NULL,1);
INSERT INTO contact_methods VALUES(3,8,1,'doooooo@sgghhh.com',NULL,1,NULL,1);
INSERT INTO contact_methods VALUES(4,9,1,'ahhh@glkbgghh.com',NULL,1,NULL,1);
INSERT INTO contact_methods VALUES(5,12,1,'notsynced@gmail.com',NULL,1,NULL,1);
CREATE TABLE extensions (_id INTEGER PRIMARY KEY AUTOINCREMENT,name TEXT NOT NULL,value TEXT NOT NULL,person INTEGER REFERENCES people(_id),UNIQUE(person, name));
CREATE TABLE fave_msg_status (_id INTEGER PRIMARY KEY, msg TEXT, next_retry INTEGER, num_retries INTEGER);
INSERT INTO fave_msg_status VALUES(100,16359444020020760201000000000000000000000000000000000000000000000000000000000000,1268764830477,2);
CREATE TABLE fave_phone_changes (_id INTEGER PRIMARY KEY, old_phone TEXT, new_phone TEXT, change_timestamp TEXT);
CREATE TABLE faves (_id INTEGER PRIMARY KEY, ui_pos INTEGER, phone TEXT NOT NULL, nickname TEXT NOT NULL, photo TEXT NOT NULL, timestamp TEXT NOT NULL, pending_phone TEXT, pending_nickname TEXT, pending_photo TEXT);
INSERT INTO faves VALUES(1,1,0,'','',000000000000,NULL,NULL,NULL);
INSERT INTO faves VALUES(2,2,0,'','',000000000000,NULL,NULL,NULL);
INSERT INTO faves VALUES(3,3,0,'','',000000000000,NULL,NULL,NULL);
INSERT INTO faves VALUES(4,4,0,'','',000000000000,NULL,NULL,NULL);
INSERT INTO faves VALUES(5,5,0,'','',000000000000,NULL,NULL,NULL);
CREATE TABLE groupmembership (_id INTEGER PRIMARY KEY,person INTEGER REFERENCES people(_id),group_id INTEGER REFERENCES groups(_id),group_sync_account STRING,group_sync_id STRING);
INSERT INTO groupmembership VALUES(3,2,NULL,'lemmytest@gmail.com',6);
INSERT INTO groupmembership VALUES(4,3,NULL,'lemmytest@gmail.com',6);
INSERT INTO groupmembership VALUES(5,4,NULL,'lemmytest@gmail.com',6);
INSERT INTO groupmembership VALUES(6,5,NULL,'lemmytest@gmail.com',6);
INSERT INTO groupmembership VALUES(7,6,NULL,'lemmytest@gmail.com',6);
INSERT INTO groupmembership VALUES(8,7,1,NULL,NULL);
INSERT INTO groupmembership VALUES(9,8,1,NULL,NULL);
INSERT INTO groupmembership VALUES(10,9,1,NULL,NULL);
INSERT INTO groupmembership VALUES(11,10,1,NULL,NULL);
INSERT INTO groupmembership VALUES(12,11,1,NULL,NULL);
INSERT INTO groupmembership VALUES(13,12,1,NULL,NULL);
CREATE TABLE groups (_id INTEGER PRIMARY KEY AUTOINCREMENT,_sync_account TEXT,_sync_id TEXT,_sync_time TEXT,_sync_version TEXT,_sync_local_id INTEGER,_sync_dirty INTEGER NOT NULL DEFAULT 0,_sync_mark INTEGER,name TEXT NOT NULL,notes TEXT,should_sync INTEGER NOT NULL DEFAULT 0,system_id TEXT,UNIQUE(name,system_id,_sync_account));
INSERT INTO groups VALUES(1,'lemmytest@gmail.com',6,NULL,NULL,NULL,0,1,'System Group: My Contacts','System Group: My Contacts',0,'Contacts');
CREATE TABLE organizations (_id INTEGER PRIMARY KEY AUTOINCREMENT,company TEXT,title TEXT,isprimary INTEGER NOT NULL DEFAULT 0,type INTEGER NOT NULL,label TEXT,person INTEGER REFERENCES people(_id));
CREATE TABLE people (_id INTEGER PRIMARY KEY AUTOINCREMENT,_sync_account TEXT,_sync_id TEXT,_sync_time TEXT,_sync_version TEXT,_sync_local_id INTEGER,_sync_dirty INTEGER NOT NULL DEFAULT 0,_sync_mark INTEGER,name TEXT COLLATE LOCALIZED,notes TEXT COLLATE LOCALIZED,times_contacted INTEGER NOT NULL DEFAULT 0,last_time_contacted INTEGER,starred INTEGER NOT NULL DEFAULT 0,primary_phone INTEGER REFERENCES phones(_id),primary_organization INTEGER REFERENCES organizations(_id),primary_email INTEGER REFERENCES contact_methods(_id),photo_version TEXT,custom_ringtone TEXT,send_to_voicemail INTEGER,phonetic_name TEXT COLLATE LOCALIZED);
INSERT INTO people VALUES(1,'non_syncable',NULL,NULL,NULL,NULL,1,1,'Lemmy Test',NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO people VALUES(2,'lemmytest@gmail.com','561d08a30def1f46',1268764045346000,1268764045346000,NULL,0,1,NULL,NULL,0,NULL,0,1,NULL,NULL,NULL,NULL,0,NULL);
INSERT INTO people VALUES(3,'lemmytest@gmail.com','506b6479896c635d',1268764047603000,1268764047603000,NULL,0,1,'Mail',NULL,0,NULL,0,NULL,NULL,1,NULL,NULL,0,NULL);
INSERT INTO people VALUES(4,'lemmytest@gmail.com','192ec38f0de81866',1268764074839000,1268764074839000,NULL,0,1,NULL,NULL,0,NULL,0,NULL,NULL,2,NULL,NULL,0,NULL);
INSERT INTO people VALUES(5,'lemmytest@gmail.com','3e879d80b2673fc',1268764126701000,1268764126701000,NULL,0,1,'Number',NULL,0,NULL,0,2,NULL,NULL,NULL,NULL,0,NULL);
INSERT INTO people VALUES(6,'lemmytest@gmail.com','4413217a0a1f5437',1268764154975000,1268764154975000,NULL,0,1,'Number And Mail',NULL,0,NULL,0,3,NULL,NULL,NULL,NULL,0,NULL);
INSERT INTO people VALUES(7,'lemmytest@gmail.com',NULL,NULL,NULL,NULL,1,NULL,'Not Synced Number',NULL,0,NULL,0,4,NULL,NULL,NULL,NULL,0,'');
INSERT INTO people VALUES(8,'lemmytest@gmail.com',NULL,NULL,NULL,NULL,1,NULL,'Not Synced NumberMail',NULL,0,NULL,0,5,NULL,3,NULL,NULL,0,'');
INSERT INTO people VALUES(9,'lemmytest@gmail.com',NULL,NULL,NULL,NULL,1,NULL,'Not Synced Mail',NULL,0,NULL,0,NULL,NULL,4,NULL,NULL,0,'');
INSERT INTO people VALUES(10,'lemmytest@gmail.com',NULL,NULL,NULL,NULL,1,NULL,'Not Synced',NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,'');
INSERT INTO people VALUES(11,'lemmytest@gmail.com',NULL,NULL,NULL,NULL,1,NULL,'',NULL,0,NULL,0,6,NULL,NULL,NULL,NULL,0,'');
INSERT INTO people VALUES(12,'lemmytest@gmail.com',NULL,NULL,NULL,NULL,1,NULL,'',NULL,0,NULL,0,NULL,NULL,5,NULL,NULL,0,'');
CREATE TABLE peopleLookup (token TEXT,source INTEGER REFERENCES people(_id),token_index INTEGER);
INSERT INTO peopleLookup VALUES('3f31414159064f314d4f',1,0);
INSERT INTO peopleLookup VALUES('4f314d4f',1,1);
INSERT INTO peopleLookup VALUES('4129393f',3,0);
INSERT INTO peopleLookup VALUES('4351412b314b',5,0);
INSERT INTO peopleLookup VALUES('4351412b314b0629432f064129393f',6,0);
INSERT INTO peopleLookup VALUES('29432f',6,1);
INSERT INTO peopleLookup VALUES('4129393f',6,2);
INSERT INTO peopleLookup VALUES('43454f064d59432d312f064351412b314b',7,0);
INSERT INTO peopleLookup VALUES('4d59432d312f',7,1);
INSERT INTO peopleLookup VALUES('4351412b314b',7,2);
INSERT INTO peopleLookup VALUES('43454f064d59432d312f064351412b314b4129393f',8,0);
INSERT INTO peopleLookup VALUES('4d59432d312f',8,1);
INSERT INTO peopleLookup VALUES('4351412b314b4129393f',8,2);
INSERT INTO peopleLookup VALUES('43454f064d59432d312f064129393f',9,0);
INSERT INTO peopleLookup VALUES('4d59432d312f',9,1);
INSERT INTO peopleLookup VALUES('4129393f',9,2);
INSERT INTO peopleLookup VALUES('43454f064d59432d312f',10,0);
INSERT INTO peopleLookup VALUES('4d59432d312f',10,1);
INSERT INTO peopleLookup VALUES('',11,0);
INSERT INTO peopleLookup VALUES('',12,0);
CREATE TABLE peopleLookupWithPhoneticName (token TEXT,source INTEGER REFERENCES people(_id),token_index INTEGER);
INSERT INTO peopleLookupWithPhoneticName VALUES('3f31414159064f314d4f',1,0);
INSERT INTO peopleLookupWithPhoneticName VALUES('4f314d4f',1,1);
INSERT INTO peopleLookupWithPhoneticName VALUES('225d',2,0);
INSERT INTO peopleLookupWithPhoneticName VALUES('4129393f',3,0);
INSERT INTO peopleLookupWithPhoneticName VALUES('225d',4,0);
INSERT INTO peopleLookupWithPhoneticName VALUES('4351412b314b',5,0);
INSERT INTO peopleLookupWithPhoneticName VALUES('4351412b314b0629432f064129393f',6,0);
INSERT INTO peopleLookupWithPhoneticName VALUES('29432f',6,1);
INSERT INTO peopleLookupWithPhoneticName VALUES('4129393f',6,2);
INSERT INTO peopleLookupWithPhoneticName VALUES('43454f064d59432d312f064351412b314b',7,0);
INSERT INTO peopleLookupWithPhoneticName VALUES('4d59432d312f',7,1);
INSERT INTO peopleLookupWithPhoneticName VALUES('4351412b314b',7,2);
INSERT INTO peopleLookupWithPhoneticName VALUES('43454f064d59432d312f064351412b314b4129393f',8,0);
INSERT INTO peopleLookupWithPhoneticName VALUES('4d59432d312f',8,1);
INSERT INTO peopleLookupWithPhoneticName VALUES('4351412b314b4129393f',8,2);
INSERT INTO peopleLookupWithPhoneticName VALUES('43454f064d59432d312f064129393f',9,0);
INSERT INTO peopleLookupWithPhoneticName VALUES('4d59432d312f',9,1);
INSERT INTO peopleLookupWithPhoneticName VALUES('4129393f',9,2);
INSERT INTO peopleLookupWithPhoneticName VALUES('43454f064d59432d312f',10,0);
INSERT INTO peopleLookupWithPhoneticName VALUES('4d59432d312f',10,1);
INSERT INTO peopleLookupWithPhoneticName VALUES('225d',11,0);
INSERT INTO peopleLookupWithPhoneticName VALUES('225d',12,0);
CREATE TABLE phones (_id INTEGER PRIMARY KEY AUTOINCREMENT,person INTEGER REFERENCES people(_id),type INTEGER NOT NULL,number TEXT,number_key TEXT,label TEXT,isprimary INTEGER NOT NULL DEFAULT 0);
INSERT INTO phones VALUES(1,2,2,'698-147-02',20741896,NULL,1);
INSERT INTO phones VALUES(2,5,2,'716-5432',2345617,NULL,1);
INSERT INTO phones VALUES(3,6,2,'542-31',13245,NULL,1);
INSERT INTO phones VALUES(4,7,2,'564-123-789',987321465,NULL,1);
INSERT INTO phones VALUES(5,8,2,'841-735-24',42537148,NULL,1);
INSERT INTO phones VALUES(6,11,2,1111111111,1111111111,NULL,1);
CREATE TABLE photos (_id INTEGER PRIMARY KEY AUTOINCREMENT,exists_on_server INTEGER NOT NULL DEFAULT 0,person INTEGER REFERENCES people(_id), local_version TEXT,data BLOB,sync_error TEXT,_sync_account TEXT,_sync_id TEXT,_sync_time TEXT,_sync_version TEXT,_sync_local_id INTEGER,_sync_dirty INTEGER NOT NULL DEFAULT 0,_sync_mark INTEGER,UNIQUE(person) );
INSERT INTO photos VALUES(1,0,1,NULL,NULL,NULL,'non_syncable',NULL,NULL,NULL,NULL,0,1);
INSERT INTO photos VALUES(2,0,2,NULL,NULL,NULL,'lemmytest@gmail.com','561d08a30def1f46','1B2M2Y8AsgTpgAmY7PhCfg','1B2M2Y8AsgTpgAmY7PhCfg',NULL,0,1);
INSERT INTO photos VALUES(3,0,3,NULL,NULL,NULL,'lemmytest@gmail.com','506b6479896c635d','1B2M2Y8AsgTpgAmY7PhCfg','1B2M2Y8AsgTpgAmY7PhCfg',NULL,0,1);
INSERT INTO photos VALUES(4,0,4,NULL,NULL,NULL,'lemmytest@gmail.com','192ec38f0de81866','1B2M2Y8AsgTpgAmY7PhCfg','1B2M2Y8AsgTpgAmY7PhCfg',NULL,0,1);
INSERT INTO photos VALUES(5,0,5,NULL,NULL,NULL,'lemmytest@gmail.com','3e879d80b2673fc','1B2M2Y8AsgTpgAmY7PhCfg','1B2M2Y8AsgTpgAmY7PhCfg',NULL,0,1);
INSERT INTO photos VALUES(6,0,6,NULL,NULL,NULL,'lemmytest@gmail.com','4413217a0a1f5437','1B2M2Y8AsgTpgAmY7PhCfg','1B2M2Y8AsgTpgAmY7PhCfg',NULL,0,1);
INSERT INTO photos VALUES(7,0,7,NULL,NULL,NULL,'lemmytest@gmail.com',NULL,NULL,NULL,NULL,0,NULL);
INSERT INTO photos VALUES(8,0,8,NULL,NULL,NULL,'lemmytest@gmail.com',NULL,NULL,NULL,NULL,0,NULL);
INSERT INTO photos VALUES(9,0,9,NULL,NULL,NULL,'lemmytest@gmail.com',NULL,NULL,NULL,NULL,0,NULL);
INSERT INTO photos VALUES(10,0,10,NULL,NULL,NULL,'lemmytest@gmail.com',NULL,NULL,NULL,NULL,0,NULL);
INSERT INTO photos VALUES(11,0,11,NULL,NULL,NULL,'lemmytest@gmail.com',NULL,NULL,NULL,NULL,0,NULL);
INSERT INTO photos VALUES(12,0,12,NULL,NULL,NULL,'lemmytest@gmail.com',NULL,NULL,NULL,NULL,0,NULL);
CREATE TABLE settings (_id INTEGER PRIMARY KEY,_sync_account TEXT,key STRING NOT NULL,value STRING );
INSERT INTO settings VALUES(1,NULL,'syncEverything',1);
CREATE TABLE sqlite_sequence(name,seq);
INSERT INTO sqlite_sequence VALUES('groups',1);
INSERT INTO sqlite_sequence VALUES('people',12);
INSERT INTO sqlite_sequence VALUES('photos',12);
INSERT INTO sqlite_sequence VALUES('phones',6);
INSERT INTO sqlite_sequence VALUES('contact_methods',5);
CREATE TABLE voice_dialer_timestamp (_id INTEGER PRIMARY KEY,timestamp INTEGER);
INSERT INTO voice_dialer_timestamp VALUES(1,1268764377);
CREATE INDEX contactMethodsPeopleIndex ON contact_methods (person);
CREATE INDEX extensionsIndex1 ON extensions (person, name);
CREATE INDEX groupmembershipIndex1 ON groupmembership (person, group_id);
CREATE INDEX groupmembershipIndex2 ON groupmembership (group_id, person);
CREATE INDEX groupmembershipIndex3 ON groupmembership (group_sync_account, group_sync_id);
CREATE INDEX groupsSyncDirtyIndex ON groups (_sync_dirty);
CREATE INDEX organizationsIndex1 ON organizations (person);
CREATE INDEX peopleLookupIndex ON peopleLookup (token,source);
CREATE INDEX peopleLookupWithPhoneticNameIndex ON peopleLookupWithPhoneticName (token,source);
CREATE INDEX peopleNameIndex ON people (name);
CREATE INDEX peopleSyncDirtyIndex ON people (_sync_dirty);
CREATE INDEX peopleSyncIdIndex ON people (_sync_id);
CREATE INDEX phonesIndex1 ON phones (person);
CREATE INDEX phonesIndex2 ON phones (number_key);
CREATE INDEX photoPersonIndex ON photos (person);
CREATE INDEX photosSyncDirtyIndex ON photos (_sync_dirty);
CREATE TRIGGER contact_cleanup DELETE ON people BEGIN DELETE FROM peopleLookup WHERE source = old._id;DELETE FROM peopleLookupWithPhoneticName WHERE source = old._id;DELETE FROM phones WHERE person = old._id;DELETE FROM contact_methods WHERE person = old._id;DELETE FROM organizations WHERE person = old._id;DELETE FROM groupmembership WHERE person = old._id;DELETE FROM extensions WHERE person = old._id;END;
CREATE TRIGGER contact_methods_INSERT_typeAndLabel AFTER INSERT ON contact_methods   WHEN (NEW.type != 0 AND NEW.label IS NOT NULL) OR         (NEW.type = 0 AND NEW.label IS NULL)   BEGIN      SELECT RAISE (ABORT, 'exactly one of type or label must be set');    END;
CREATE TRIGGER contact_methods_UPDATE_typeAndLabel AFTER UPDATE ON contact_methods   WHEN (NEW.type != 0 AND NEW.label IS NOT NULL) OR         (NEW.type = 0 AND NEW.label IS NULL)   BEGIN      SELECT RAISE (ABORT, 'exactly one of type or label must be set');    END;
CREATE TRIGGER contact_methods_delete DELETE ON contact_methods BEGIN UPDATE people SET _sync_dirty=1 WHERE people._id=old.person;END;
CREATE TRIGGER contact_methods_insert INSERT ON contact_methods BEGIN UPDATE people SET _sync_dirty=1 WHERE people._id=new.person;END;
CREATE TRIGGER contact_methods_update UPDATE ON contact_methods BEGIN UPDATE people SET _sync_dirty=1 WHERE people._id=old.person;END;
CREATE TRIGGER extensions_delete DELETE ON extensions BEGIN UPDATE people SET _sync_dirty=1 WHERE people._id=old.person;END;
CREATE TRIGGER extensions_insert INSERT ON extensions BEGIN UPDATE people SET _sync_dirty=1 WHERE people._id=new.person; END;
CREATE TRIGGER extensions_update AFTER UPDATE ON extensions BEGIN UPDATE people SET _sync_dirty=1 WHERE people._id=old.person; END;
CREATE TRIGGER groupmembership_delete DELETE ON groupmembership BEGIN UPDATE people SET _sync_dirty=1 WHERE people._id=old.person;END;
CREATE TRIGGER groupmembership_insert INSERT ON groupmembership BEGIN UPDATE people SET _sync_dirty=1 WHERE people._id=new.person; END;
CREATE TRIGGER groupmembership_update AFTER UPDATE ON groupmembership BEGIN UPDATE people SET _sync_dirty=1 WHERE people._id=old.person; END;
CREATE TRIGGER groups_cleanup DELETE ON groups BEGIN UPDATE groupmembership SET group_id = null WHERE group_id = old._id;END;
CREATE TRIGGER groups_to_deleted DELETE ON groups WHEN old._sync_id is not null BEGIN INSERT INTO _deleted_groups (_sync_id, _sync_account, _sync_version) VALUES (old._sync_id, old._sync_account, old._sync_version);END;
CREATE TRIGGER organizations_INSERT_typeAndLabel AFTER INSERT ON organizations   WHEN (NEW.type != 0 AND NEW.label IS NOT NULL) OR         (NEW.type = 0 AND NEW.label IS NULL)   BEGIN      SELECT RAISE (ABORT, 'exactly one of type or label must be set');    END;
CREATE TRIGGER organizations_UPDATE_typeAndLabel AFTER UPDATE ON organizations   WHEN (NEW.type != 0 AND NEW.label IS NOT NULL) OR         (NEW.type = 0 AND NEW.label IS NULL)   BEGIN      SELECT RAISE (ABORT, 'exactly one of type or label must be set');    END;
CREATE TRIGGER organizations_delete DELETE ON organizations BEGIN UPDATE people SET _sync_dirty=1 WHERE people._id=old.person;END;
CREATE TRIGGER organizations_insert INSERT ON organizations BEGIN UPDATE people SET _sync_dirty=1 WHERE people._id=new.person; END;
CREATE TRIGGER organizations_update AFTER UPDATE ON organizations BEGIN UPDATE people SET _sync_dirty=1 WHERE people._id=old.person; END;
CREATE TRIGGER peopleDeleteAndPhotos DELETE ON people  BEGIN   DELETE FROM photos WHERE person=OLD._id; END;
CREATE TRIGGER peopleLookupWithPhoneticName_insert AFTER INSERT ON people BEGIN SELECT _TOKENIZE('peopleLookupWithPhoneticName', new._id, GET_NORMALIZED_STRING(CASE WHEN (new.phonetic_name IS NOT NULL AND new.phonetic_name != '') THEN new.phonetic_name ELSE (CASE WHEN (new.name is NOT NULL AND new.name != '') THEN new.name ELSE '' END) END), ' ', 1);END;
CREATE TRIGGER peopleLookupWithPhoneticName_update UPDATE OF name, phonetic_name ON people BEGIN DELETE FROM peopleLookupWithPhoneticName WHERE source = new._id;SELECT _TOKENIZE('peopleLookupWithPhoneticName', new._id, GET_NORMALIZED_STRING(CASE WHEN (new.phonetic_name IS NOT NULL AND new.phonetic_name != '') THEN new.phonetic_name ELSE (CASE WHEN (new.name is NOT NULL AND new.name != '') THEN new.name ELSE '' END) END), ' ', 1);END;
CREATE TRIGGER peopleLookup_insert AFTER INSERT ON people BEGIN SELECT _TOKENIZE('peopleLookup', new._id, new.name, ' ', 1);END;
CREATE TRIGGER peopleLookup_update UPDATE OF name ON people BEGIN DELETE FROM peopleLookup WHERE source = new._id;SELECT _TOKENIZE('peopleLookup', new._id, new.name, ' ', 1);END;
CREATE TRIGGER people_timesContacted UPDATE OF last_time_contacted ON people BEGIN UPDATE people SET times_contacted = (new.times_contacted + 1) WHERE _id = new._id;END;
CREATE TRIGGER phones_INSERT_typeAndLabel AFTER INSERT ON phones   WHEN (NEW.type != 0 AND NEW.label IS NOT NULL) OR         (NEW.type = 0 AND NEW.label IS NULL)   BEGIN      SELECT RAISE (ABORT, 'exactly one of type or label must be set');    END;
CREATE TRIGGER phones_UPDATE_typeAndLabel AFTER UPDATE ON phones   WHEN (NEW.type != 0 AND NEW.label IS NOT NULL) OR         (NEW.type = 0 AND NEW.label IS NULL)   BEGIN      SELECT RAISE (ABORT, 'exactly one of type or label must be set');    END;
CREATE TRIGGER phones_delete DELETE ON phones BEGIN UPDATE people SET _sync_dirty=1 WHERE people._id=old.person;END;
CREATE TRIGGER phones_insert INSERT ON phones BEGIN UPDATE people SET _sync_dirty=1 WHERE people._id=new.person;END;
CREATE TRIGGER phones_update UPDATE ON phones BEGIN UPDATE people SET _sync_dirty=1 WHERE people._id=old.person;END;
CREATE TRIGGER timestamp_trigger1 AFTER UPDATE ON phones BEGIN UPDATE voice_dialer_timestamp SET timestamp=strftime('%s', 'now') WHERE _id=1;END;
CREATE TRIGGER timestamp_trigger2 AFTER UPDATE OF name ON people BEGIN UPDATE voice_dialer_timestamp SET timestamp=strftime('%s', 'now') WHERE _id=1;END;
COMMIT;
