BEGIN TRANSACTION;
PRAGMA user_version = 82; 
CREATE TABLE _deleted_groups (_sync_version TEXT,_sync_id TEXT,_sync_account TEXT,_sync_mark INTEGER);
CREATE TABLE _deleted_people (_sync_version TEXT,_sync_id TEXT,_sync_account TEXT,_sync_mark INTEGER);
INSERT INTO _deleted_people VALUES(1249441421793000,'20d08a710c3df43d','android.contacts.test.eclair@gmail.com',NULL);
CREATE TABLE _sync_state (_id INTEGER PRIMARY KEY,_sync_account TEXT,data TEXT,UNIQUE(_sync_account));
INSERT INTO _sync_state VALUES(1,'android.contacts.test.eclair@gmail.com','');
CREATE TABLE _sync_state_metadata (version INTEGER);
INSERT INTO _sync_state_metadata VALUES(2);
CREATE TABLE android_metadata (locale TEXT);
INSERT INTO android_metadata VALUES('en_US');
CREATE TABLE calls (_id INTEGER PRIMARY KEY AUTOINCREMENT,number TEXT,date INTEGER,duration INTEGER,type INTEGER,new INTEGER,name TEXT,numbertype INTEGER,numberlabel TEXT);
INSERT INTO calls VALUES(1,18004664411,1249177360040,10,2,1,'Jane Doe',1,NULL);
CREATE TABLE contact_methods (_id INTEGER PRIMARY KEY AUTOINCREMENT,person INTEGER REFERENCES people(_id),kind INTEGER NOT NULL,data TEXT,aux_data TEXT,type INTEGER NOT NULL,label TEXT,isprimary INTEGER NOT NULL DEFAULT 0);
INSERT INTO contact_methods VALUES(1,2,1,'a@acme.com',NULL,1,NULL,1);
INSERT INTO contact_methods VALUES(2,2,1,'b@acme.com',NULL,2,NULL,0);
INSERT INTO contact_methods VALUES(3,2,1,'c@acme.com',NULL,3,NULL,0);
INSERT INTO contact_methods VALUES(4,2,1,'d@acme.com',NULL,3,NULL,0);
INSERT INTO contact_methods VALUES(5,2,3,'a','pre:5',3,NULL,0);
INSERT INTO contact_methods VALUES(6,2,3,'b','pre:0',3,NULL,0);
INSERT INTO contact_methods VALUES(7,2,3,'c','pre:2',3,NULL,0);
INSERT INTO contact_methods VALUES(8,2,3,'d','pre:3',3,NULL,0);
INSERT INTO contact_methods VALUES(9,2,3,'e','pre:4',3,NULL,0);
INSERT INTO contact_methods VALUES(10,2,3,'f','pre:1',3,NULL,0);
INSERT INTO contact_methods VALUES(11,2,3,'g','pre:6',3,NULL,0);
INSERT INTO contact_methods VALUES(12,2,3,'h','pre:7',3,NULL,0);
INSERT INTO contact_methods VALUES(13,3,1,'deer@acme.com',NULL,2,NULL,1);
INSERT INTO contact_methods VALUES(14,3,2,'12345 Main Street
Main Town, CA 95000',NULL,2,NULL,0);
INSERT INTO contact_methods VALUES(15,3,3,'deerdough','pre:5',3,NULL,0);
CREATE TABLE extensions (_id INTEGER PRIMARY KEY AUTOINCREMENT,name TEXT NOT NULL,value TEXT NOT NULL,person INTEGER REFERENCES people(_id),UNIQUE(person, name));
CREATE TABLE fave_msg_status (_id INTEGER PRIMARY KEY, msg TEXT, next_retry INTEGER, num_retries INTEGER);
CREATE TABLE fave_phone_changes (_id INTEGER PRIMARY KEY, old_phone TEXT, new_phone TEXT, change_timestamp TEXT);
CREATE TABLE faves (_id INTEGER PRIMARY KEY, ui_pos INTEGER, phone TEXT NOT NULL, nickname TEXT NOT NULL, photo TEXT NOT NULL, timestamp TEXT NOT NULL, pending_phone TEXT, pending_nickname TEXT, pending_photo TEXT);
INSERT INTO faves VALUES(1,1,0,'','',000000000000,NULL,NULL,NULL);
INSERT INTO faves VALUES(2,2,0,'','',000000000000,NULL,NULL,NULL);
INSERT INTO faves VALUES(3,3,0,'','',000000000000,NULL,NULL,NULL);
INSERT INTO faves VALUES(4,4,0,'','',000000000000,NULL,NULL,NULL);
INSERT INTO faves VALUES(5,5,0,'','',000000000000,NULL,NULL,NULL);
CREATE TABLE groupmembership (_id INTEGER PRIMARY KEY,person INTEGER REFERENCES people(_id),group_id INTEGER REFERENCES groups(_id),group_sync_account STRING,group_sync_id STRING);
INSERT INTO groupmembership VALUES(1,2,NULL,'android.contacts.test.eclair@gmail.com',6);
INSERT INTO groupmembership VALUES(2,3,NULL,'android.contacts.test.eclair@gmail.com',6);
INSERT INTO groupmembership VALUES(3,3,NULL,'android.contacts.test.eclair@gmail.com','20a186238cf27aaa');
INSERT INTO groupmembership VALUES(9,3,NULL,'android.contacts.test.eclair@gmail.com',55555555555);
INSERT INTO groupmembership VALUES(10,11,1,NULL,NULL);
INSERT INTO groupmembership VALUES(11,2,3,'android.contacts.test.eclair@gmail.com','2fcbf74c8be345dc');
CREATE TABLE groups (_id INTEGER PRIMARY KEY AUTOINCREMENT,_sync_account TEXT,_sync_id TEXT,_sync_time TEXT,_sync_version TEXT,_sync_local_id INTEGER,_sync_dirty INTEGER NOT NULL DEFAULT 0,_sync_mark INTEGER,name TEXT NOT NULL,notes TEXT,should_sync INTEGER NOT NULL DEFAULT 0,system_id TEXT,UNIQUE(name,system_id,_sync_account));
INSERT INTO groups VALUES(1,'android.contacts.test.eclair@gmail.com',6,NULL,NULL,NULL,0,1,'System Group: My Contacts','System Group: My Contacts',0,'Contacts');
INSERT INTO groups VALUES(2,'android.contacts.test.eclair@gmail.com','20a186238cf27aaa',1249172992736000,1249172992736000,NULL,0,1,'Eclair Contacts','Eclair Contacts',0,NULL);
INSERT INTO groups VALUES(3,'android.contacts.test.eclair@gmail.com','2fcbf74c8be345dc',1249176693566000,1249176693566000,NULL,0,1,'Starred in Android','Starred in Android',0,NULL);
CREATE TABLE organizations (_id INTEGER PRIMARY KEY AUTOINCREMENT,company TEXT,title TEXT,isprimary INTEGER NOT NULL DEFAULT 0,type INTEGER NOT NULL,label TEXT,person INTEGER REFERENCES people(_id));
INSERT INTO organizations VALUES(1,'Acme Corp','President',0,1,NULL,3);
CREATE TABLE people (_id INTEGER PRIMARY KEY AUTOINCREMENT,_sync_account TEXT,_sync_id TEXT,_sync_time TEXT,_sync_version TEXT,_sync_local_id INTEGER,_sync_dirty INTEGER NOT NULL DEFAULT 0,_sync_mark INTEGER,name TEXT COLLATE LOCALIZED,notes TEXT COLLATE LOCALIZED,times_contacted INTEGER NOT NULL DEFAULT 0,last_time_contacted INTEGER,starred INTEGER NOT NULL DEFAULT 0,primary_phone INTEGER REFERENCES phones(_id),primary_organization INTEGER REFERENCES organizations(_id),primary_email INTEGER REFERENCES contact_methods(_id),photo_version TEXT,custom_ringtone TEXT,send_to_voicemail INTEGER,phonetic_name TEXT COLLATE LOCALIZED);
INSERT INTO people VALUES(1,'non_syncable',NULL,NULL,NULL,NULL,1,1,'Test Android',NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO people VALUES(2,'android.contacts.test.eclair@gmail.com','3d09f37e0f0dbc6f',1249441106583000,1249441106583000,NULL,1,1,'Jane Doe',NULL,1,1249177384979,1,1,NULL,1,NULL,NULL,NULL,NULL);
INSERT INTO people VALUES(3,'android.contacts.test.eclair@gmail.com','5c9ae978b346ac9',1249441067558000,1249441067558000,NULL,1,1,'John Doe','This is a test account for Eclair Android Contacts',0,NULL,1,8,1,13,NULL,'content://media/internal/audio/media/80',1,NULL);
INSERT INTO people VALUES(11,'android.contacts.test.eclair@gmail.com',NULL,NULL,NULL,NULL,1,NULL,'Added On Android',NULL,0,NULL,0,16,NULL,NULL,NULL,NULL,0,'');
CREATE TABLE peopleLookup (token TEXT,source INTEGER REFERENCES people(_id),token_index INTEGER);
INSERT INTO peopleLookup VALUES('4f314d4f0629432f4b45392f',1,0);
INSERT INTO peopleLookup VALUES('29432f4b45392f',1,1);
INSERT INTO peopleLookup VALUES('3b294331062f4531',2,0);
INSERT INTO peopleLookup VALUES('2f4531',2,1);
INSERT INTO peopleLookup VALUES('3b453743062f4531',3,0);
INSERT INTO peopleLookup VALUES('2f4531',3,1);
INSERT INTO peopleLookup VALUES('292f2f312f0645430629432f4b45392f',11,0);
INSERT INTO peopleLookup VALUES(4543,11,1);
INSERT INTO peopleLookup VALUES('29432f4b45392f',11,2);
CREATE TABLE peopleLookupWithPhoneticName (token TEXT,source INTEGER REFERENCES people(_id),token_index INTEGER);
INSERT INTO peopleLookupWithPhoneticName VALUES('4f314d4f0629432f4b45392f',1,0);
INSERT INTO peopleLookupWithPhoneticName VALUES('29432f4b45392f',1,1);
INSERT INTO peopleLookupWithPhoneticName VALUES('3b294331062f4531',2,0);
INSERT INTO peopleLookupWithPhoneticName VALUES('2f4531',2,1);
INSERT INTO peopleLookupWithPhoneticName VALUES('3b453743062f4531',3,0);
INSERT INTO peopleLookupWithPhoneticName VALUES('2f4531',3,1);
INSERT INTO peopleLookupWithPhoneticName VALUES('292f2f312f0645430629432f4b45392f',11,0);
INSERT INTO peopleLookupWithPhoneticName VALUES(4543,11,1);
INSERT INTO peopleLookupWithPhoneticName VALUES('29432f4b45392f',11,2);
CREATE TABLE phones (_id INTEGER PRIMARY KEY AUTOINCREMENT,person INTEGER REFERENCES people(_id),type INTEGER NOT NULL,number TEXT,number_key TEXT,label TEXT,isprimary INTEGER NOT NULL DEFAULT 0);
INSERT INTO phones VALUES(1,2,1,'1-800-466-4411',11446640081,NULL,1);
INSERT INTO phones VALUES(2,2,3,2345678901,1098765432,NULL,0);
INSERT INTO phones VALUES(3,2,2,3456789012,2109876543,NULL,0);
INSERT INTO phones VALUES(4,2,5,4567890123,3210987654,NULL,0);
INSERT INTO phones VALUES(5,2,4,5678901234,4321098765,NULL,0);
INSERT INTO phones VALUES(6,2,6,6789012345,5432109876,NULL,0);
INSERT INTO phones VALUES(7,2,7,7890123456,6543210987,NULL,0);
INSERT INTO phones VALUES(8,3,2,'555-555-5555',5555555555,NULL,0);
INSERT INTO phones VALUES(11,2,1,1234567890,0987654321,NULL,0);
INSERT INTO phones VALUES(16,11,2,'1-987-4563',36547891,NULL,1);
CREATE TABLE photos (_id INTEGER PRIMARY KEY AUTOINCREMENT,exists_on_server INTEGER NOT NULL DEFAULT 0,person INTEGER REFERENCES people(_id), local_version TEXT,data BLOB,sync_error TEXT,_sync_account TEXT,_sync_id TEXT,_sync_time TEXT,_sync_version TEXT,_sync_local_id INTEGER,_sync_dirty INTEGER NOT NULL DEFAULT 0,_sync_mark INTEGER,UNIQUE(person) );
INSERT INTO photos VALUES(1,0,1,NULL,NULL,NULL,'non_syncable',NULL,NULL,NULL,NULL,0,1);
INSERT INTO photos VALUES(2,1,2,'4Yujp-X7nRp5v8zJca7cxg','����',NULL,'android.contacts.test.eclair@gmail.com','3d09f37e0f0dbc6f','4Yujp-X7nRp5v8zJca7cxg','4Yujp-X7nRp5v8zJca7cxg',NULL,0,1);
INSERT INTO photos VALUES(3,1,3,'sQwgwiST8gBzusqDIFkOgg','����',NULL,'android.contacts.test.eclair@gmail.com','5c9ae978b346ac9','sQwgwiST8gBzusqDIFkOgg','sQwgwiST8gBzusqDIFkOgg',NULL,0,1);
INSERT INTO photos VALUES(11,0,11,NULL,NULL,NULL,'android.contacts.test.eclair@gmail.com',NULL,NULL,NULL,NULL,0,NULL);
CREATE TABLE settings (_id INTEGER PRIMARY KEY,_sync_account TEXT,key STRING NOT NULL,value STRING );
INSERT INTO settings VALUES(1,NULL,'syncEverything',1);
CREATE TABLE sqlite_sequence(name,seq);
INSERT INTO sqlite_sequence VALUES('groups',3);
INSERT INTO sqlite_sequence VALUES('people',11);
INSERT INTO sqlite_sequence VALUES('photos',11);
INSERT INTO sqlite_sequence VALUES('phones',16);
INSERT INTO sqlite_sequence VALUES('contact_methods',24);
INSERT INTO sqlite_sequence VALUES('organizations',2);
INSERT INTO sqlite_sequence VALUES('calls',1);
CREATE TABLE voice_dialer_timestamp (_id INTEGER PRIMARY KEY,timestamp INTEGER);
INSERT INTO voice_dialer_timestamp VALUES(1,1249441215);
CREATE INDEX contactMethodsPeopleIndex ON contact_methods (person);
CREATE INDEX extensionsIndex1 ON extensions (person, name);
CREATE INDEX groupmembershipIndex1 ON groupmembership (person, group_id);
CREATE INDEX groupmembershipIndex2 ON groupmembership (group_id, person);
CREATE INDEX groupmembershipIndex3 ON groupmembership (group_sync_account, group_sync_id);
CREATE INDEX groupsSyncDirtyIndex ON groups (_sync_dirty);
CREATE INDEX organizationsIndex1 ON organizations (person);
CREATE INDEX peopleLookupIndex ON peopleLookup (token,source);
CREATE INDEX peopleLookupWithPhoneticNameIndex ON peopleLookupWithPhoneticName (token,source);
CREATE INDEX peopleNameIndex ON people (name);
CREATE INDEX peopleSyncDirtyIndex ON people (_sync_dirty);
CREATE INDEX peopleSyncIdIndex ON people (_sync_id);
CREATE INDEX phonesIndex1 ON phones (person);
CREATE INDEX phonesIndex2 ON phones (number_key);
CREATE INDEX photoPersonIndex ON photos (person);
CREATE INDEX photosSyncDirtyIndex ON photos (_sync_dirty);
CREATE TRIGGER contact_cleanup DELETE ON people BEGIN DELETE FROM peopleLookup WHERE source = old._id;DELETE FROM peopleLookupWithPhoneticName WHERE source = old._id;DELETE FROM phones WHERE person = old._id;DELETE FROM contact_methods WHERE person = old._id;DELETE FROM organizations WHERE person = old._id;DELETE FROM groupmembership WHERE person = old._id;DELETE FROM extensions WHERE person = old._id;END;
CREATE TRIGGER contact_methods_INSERT_typeAndLabel AFTER INSERT ON contact_methods   WHEN (NEW.type != 0 AND NEW.label IS NOT NULL) OR         (NEW.type = 0 AND NEW.label IS NULL)   BEGIN      SELECT RAISE (ABORT, 'exactly one of type or label must be set');    END;
CREATE TRIGGER contact_methods_UPDATE_typeAndLabel AFTER UPDATE ON contact_methods   WHEN (NEW.type != 0 AND NEW.label IS NOT NULL) OR         (NEW.type = 0 AND NEW.label IS NULL)   BEGIN      SELECT RAISE (ABORT, 'exactly one of type or label must be set');    END;
CREATE TRIGGER contact_methods_delete DELETE ON contact_methods BEGIN UPDATE people SET _sync_dirty=1 WHERE people._id=old.person;END;
CREATE TRIGGER contact_methods_insert INSERT ON contact_methods BEGIN UPDATE people SET _sync_dirty=1 WHERE people._id=new.person;END;
CREATE TRIGGER contact_methods_update UPDATE ON contact_methods BEGIN UPDATE people SET _sync_dirty=1 WHERE people._id=old.person;END;
CREATE TRIGGER extensions_delete DELETE ON extensions BEGIN UPDATE people SET _sync_dirty=1 WHERE people._id=old.person;END;
CREATE TRIGGER extensions_insert INSERT ON extensions BEGIN UPDATE people SET _sync_dirty=1 WHERE people._id=new.person; END;
CREATE TRIGGER extensions_update AFTER UPDATE ON extensions BEGIN UPDATE people SET _sync_dirty=1 WHERE people._id=old.person; END;
CREATE TRIGGER groupmembership_delete DELETE ON groupmembership BEGIN UPDATE people SET _sync_dirty=1 WHERE people._id=old.person;END;
CREATE TRIGGER groupmembership_insert INSERT ON groupmembership BEGIN UPDATE people SET _sync_dirty=1 WHERE people._id=new.person; END;
CREATE TRIGGER groupmembership_update AFTER UPDATE ON groupmembership BEGIN UPDATE people SET _sync_dirty=1 WHERE people._id=old.person; END;
CREATE TRIGGER groups_cleanup DELETE ON groups BEGIN UPDATE groupmembership SET group_id = null WHERE group_id = old._id;END;
CREATE TRIGGER groups_to_deleted DELETE ON groups WHEN old._sync_id is not null BEGIN INSERT INTO _deleted_groups (_sync_id, _sync_account, _sync_version) VALUES (old._sync_id, old._sync_account, old._sync_version);END;
CREATE TRIGGER organizations_INSERT_typeAndLabel AFTER INSERT ON organizations   WHEN (NEW.type != 0 AND NEW.label IS NOT NULL) OR         (NEW.type = 0 AND NEW.label IS NULL)   BEGIN      SELECT RAISE (ABORT, 'exactly one of type or label must be set');    END;
CREATE TRIGGER organizations_UPDATE_typeAndLabel AFTER UPDATE ON organizations   WHEN (NEW.type != 0 AND NEW.label IS NOT NULL) OR         (NEW.type = 0 AND NEW.label IS NULL)   BEGIN      SELECT RAISE (ABORT, 'exactly one of type or label must be set');    END;
CREATE TRIGGER organizations_delete DELETE ON organizations BEGIN UPDATE people SET _sync_dirty=1 WHERE people._id=old.person;END;
CREATE TRIGGER organizations_insert INSERT ON organizations BEGIN UPDATE people SET _sync_dirty=1 WHERE people._id=new.person; END;
CREATE TRIGGER organizations_update AFTER UPDATE ON organizations BEGIN UPDATE people SET _sync_dirty=1 WHERE people._id=old.person; END;
CREATE TRIGGER peopleDeleteAndPhotos DELETE ON people  BEGIN   DELETE FROM photos WHERE person=OLD._id; END;
CREATE TRIGGER peopleLookupWithPhoneticName_insert AFTER INSERT ON people BEGIN SELECT _TOKENIZE('peopleLookupWithPhoneticName', new._id, GET_NORMALIZED_STRING(CASE WHEN (new.phonetic_name IS NOT NULL AND new.phonetic_name != '') THEN new.phonetic_name ELSE (CASE WHEN (new.name is NOT NULL AND new.name != '') THEN new.name ELSE '' END) END), ' ', 1);END;
CREATE TRIGGER peopleLookupWithPhoneticName_update UPDATE OF name, phonetic_name ON people BEGIN DELETE FROM peopleLookupWithPhoneticName WHERE source = new._id;SELECT _TOKENIZE('peopleLookupWithPhoneticName', new._id, GET_NORMALIZED_STRING(CASE WHEN (new.phonetic_name IS NOT NULL AND new.phonetic_name != '') THEN new.phonetic_name ELSE (CASE WHEN (new.name is NOT NULL AND new.name != '') THEN new.name ELSE '' END) END), ' ', 1);END;
CREATE TRIGGER peopleLookup_insert AFTER INSERT ON people BEGIN SELECT _TOKENIZE('peopleLookup', new._id, new.name, ' ', 1);END;
CREATE TRIGGER peopleLookup_update UPDATE OF name ON people BEGIN DELETE FROM peopleLookup WHERE source = new._id;SELECT _TOKENIZE('peopleLookup', new._id, new.name, ' ', 1);END;
CREATE TRIGGER people_timesContacted UPDATE OF last_time_contacted ON people BEGIN UPDATE people SET times_contacted = (new.times_contacted + 1) WHERE _id = new._id;END;
CREATE TRIGGER phones_INSERT_typeAndLabel AFTER INSERT ON phones   WHEN (NEW.type != 0 AND NEW.label IS NOT NULL) OR         (NEW.type = 0 AND NEW.label IS NULL)   BEGIN      SELECT RAISE (ABORT, 'exactly one of type or label must be set');    END;
CREATE TRIGGER phones_UPDATE_typeAndLabel AFTER UPDATE ON phones   WHEN (NEW.type != 0 AND NEW.label IS NOT NULL) OR         (NEW.type = 0 AND NEW.label IS NULL)   BEGIN      SELECT RAISE (ABORT, 'exactly one of type or label must be set');    END;
CREATE TRIGGER phones_delete DELETE ON phones BEGIN UPDATE people SET _sync_dirty=1 WHERE people._id=old.person;END;
CREATE TRIGGER phones_insert INSERT ON phones BEGIN UPDATE people SET _sync_dirty=1 WHERE people._id=new.person;END;
CREATE TRIGGER phones_update UPDATE ON phones BEGIN UPDATE people SET _sync_dirty=1 WHERE people._id=old.person;END;
CREATE TRIGGER timestamp_trigger1 AFTER UPDATE ON phones BEGIN UPDATE voice_dialer_timestamp SET timestamp=strftime('%s', 'now') WHERE _id=1;END;
CREATE TRIGGER timestamp_trigger2 AFTER UPDATE OF name ON people BEGIN UPDATE voice_dialer_timestamp SET timestamp=strftime('%s', 'now') WHERE _id=1;END;
COMMIT;
