/*
 * Copyright (C) 2010 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.quicksearchbox;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/**
 * A corpus ranker that orders corpora lexicographically by name.
 */
public class LexicographicalCorpusRanker extends AbstractCorpusRanker {

    public LexicographicalCorpusRanker(Corpora corpora) {
        super(corpora);
    }

    @Override
    public List<Corpus> rankCorpora(Corpora corpora) {
        ArrayList<Corpus> ordered = new ArrayList<Corpus>(corpora.getEnabledCorpora());
        Collections.sort(ordered, new Comparator<Corpus>() {
            public int compare(Corpus c1, Corpus c2) {
                return c1.getName().compareTo(c2.getName());
            }
        });
        return ordered;
    }
}
