/*
 * Decompiled with CFR 0.152.
 */
package org.javia.arity;

import org.javia.arity.ArityException;
import org.javia.arity.Complex;
import org.javia.arity.Function;
import org.javia.arity.FunctionAndName;
import org.javia.arity.MoreMath;
import org.javia.arity.MyFun;
import org.javia.arity.Symbol;
import org.javia.arity.Symbols;
import org.javia.arity.SyntaxException;
import org.javia.arity.TestEval;
import org.javia.arity.TestFormat;
import org.javia.arity.Util;

public class UnitTest {
    private static final String[] profileCases = new String[]{"(100.5 + 20009.999)*(7+4+3)/(5/2)^3!)*2", "fun1(x)=(x+2)*(x+3)", "otherFun(x)=(fun1(x-1)*x+1)*(fun1(2-x)+10)", "log(x+30.5, 3)^.7*sin(x+.5)"};
    static boolean allOk = true;
    static int checkCounter = 0;

    public static void main(String[] stringArray) throws SyntaxException, ArityException {
        int n = stringArray.length;
        if (n == 0) {
            UnitTest.runUnitTests();
        } else if (stringArray[0].equals("-profile")) {
            if (n == 1) {
                UnitTest.profile();
            } else {
                Symbols symbols = new Symbols();
                for (int i = 1; i < n - 1; ++i) {
                    FunctionAndName functionAndName = symbols.compileWithName(stringArray[i]);
                    symbols.define(functionAndName);
                }
                UnitTest.profile(symbols, stringArray[n - 1]);
            }
        } else {
            Symbols symbols = new Symbols();
            for (int i = 0; i < n; ++i) {
                FunctionAndName functionAndName = symbols.compileWithName(stringArray[i]);
                symbols.define(functionAndName);
                Function function = functionAndName.function;
                System.out.println(stringArray[i] + " : " + function);
            }
        }
    }

    static void profile(Symbols symbols, String string) throws SyntaxException, ArityException {
        Function function = symbols.compile(string);
        System.out.println("\n" + string + ": " + function);
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        runtime.gc();
        long l = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            symbols.compile(string);
        }
        long l2 = System.currentTimeMillis();
        System.out.println("compilation time: " + (l2 - l) + " us");
        double[] dArray = new double[function.arity()];
        runtime.gc();
        l = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            function.eval(dArray);
        }
        l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        System.out.println("execution time: " + (l3 > 100L ? "" + (double)l3 / 100.0 + " us" : "" + l3 + " ns"));
    }

    private static void profile() {
        String[] stringArray = profileCases;
        Symbols symbols = new Symbols();
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                symbols.define(symbols.compileWithName(stringArray[i]));
                UnitTest.profile(symbols, stringArray[i]);
            }
        }
        catch (SyntaxException syntaxException) {
            throw new Error("" + syntaxException);
        }
    }

    static void runUnitTests() {
        checkCounter = 0;
        UnitTest.check(Util.doubleToString(Double.NEGATIVE_INFINITY, 5).equals("-Infinity"));
        UnitTest.check(Util.doubleToString(Double.NaN, 5).equals("NaN"));
        Complex complex = new Complex();
        Complex complex2 = new Complex();
        Complex complex3 = new Complex();
        UnitTest.check(Util.complexToString(complex.set(0.0, -1.0), 10, 1).equals("-i"));
        UnitTest.check(Util.complexToString(complex.set(2.123, 0.0), 3, 0).equals("2.1"));
        UnitTest.check(Util.complexToString(complex.set(0.0, 1.0000000000001), 20, 3).equals("i"));
        UnitTest.check(Util.complexToString(complex.set(1.0, -1.0), 10, 1).equals("1-i"));
        UnitTest.check(Util.complexToString(complex.set(1.0, 1.0), 10, 1).equals("1+i"));
        UnitTest.check(Util.complexToString(complex.set(1.12, 1.12), 9, 0).equals("1.12+1.1i"));
        UnitTest.check(Util.complexToString(complex.set(1.12345, -1.0), 7, 0).equals("1.123-i"));
        UnitTest.check(complex.set(-1.0, 0.0).pow(complex2.set(0.0, 1.0)), complex3.set(0.04321391826377226, 0.0));
        UnitTest.check(complex.set(-1.0, 0.0).pow(complex2.set(1.0, 1.0)), complex3.set(-0.04321391826377226, 0.0));
        UnitTest.check(complex.set(-1.0, 0.0).abs(), 1.0);
        UnitTest.check(complex.set(7.3890560989306495, 0.0).log(), complex2.set(2.0, 0.0));
        UnitTest.check(complex.set(-1.0, 0.0).log(), complex2.set(0.0, Math.PI));
        UnitTest.check(complex.set(2.0, 0.0).exp(), complex2.set(7.3890560989306495, 0.0));
        UnitTest.check(complex.set(0.0, Math.PI).exp(), complex2.set(-1.0, 0.0));
        UnitTest.check(MoreMath.lgamma(1.0), 0.0);
        UnitTest.check(complex.set(1.0, 0.0).lgamma(), complex2.set(0.0, 0.0));
        UnitTest.check(complex.set(0.0, 0.0).factorial(), complex2.set(1.0, 0.0));
        UnitTest.check(complex.set(1.0, 0.0).factorial(), complex2.set(1.0, 0.0));
        UnitTest.check(complex.set(0.0, 1.0).factorial(), complex2.set(0.49801566811835596, -0.1549498283018106));
        UnitTest.check(complex.set(-2.0, 1.0).factorial(), complex2.set(-0.17153291990834815, 0.32648274821006623));
        UnitTest.check(complex.set(4.0, 0.0).factorial(), complex2.set(24.0, 0.0));
        UnitTest.check(complex.set(4.0, 3.0).factorial(), complex2.set(0.016041882741649555, -9.433293289755953));
        UnitTest.check(Math.log(-1.0), Double.NaN);
        UnitTest.check(Math.log(-0.03), Double.NaN);
        UnitTest.check(MoreMath.intLog10(-0.03), 0.0);
        UnitTest.check(MoreMath.intLog10(0.03), -2.0);
        UnitTest.check(MoreMath.intExp10(3), 1000.0);
        UnitTest.check(MoreMath.intExp10(-1), 0.1);
        UnitTest.check(Util.shortApprox(1.235, 0.02), 1.24);
        UnitTest.check(Util.shortApprox(1.235, 0.4), 1.2000000000000002);
        UnitTest.check(Util.shortApprox(-1.235, 0.02), -1.24);
        UnitTest.check(Util.shortApprox(-1.235, 0.4), -1.2000000000000002);
        UnitTest.check(TestFormat.testFormat());
        UnitTest.check(TestEval.testEval());
        UnitTest.check(UnitTest.testRecursiveEval());
        UnitTest.check(UnitTest.testFrame());
        UnitTest.check(TestFormat.testSizeCases());
        if (!allOk) {
            System.out.println("\n*** Some tests FAILED ***\n");
            System.exit(1);
        } else {
            System.out.println("\n*** All tests passed OK ***\n");
        }
    }

    static boolean testFrame() {
        boolean bl = true;
        try {
            Symbols symbols = new Symbols();
            symbols.define("a", 1.0);
            bl = bl && symbols.eval("a") == 1.0;
            symbols.pushFrame();
            bl = bl && symbols.eval("a") == 1.0;
            symbols.define("a", 2.0);
            bl = bl && symbols.eval("a") == 2.0;
            symbols.define("a", 3.0);
            bl = bl && symbols.eval("a") == 3.0;
            symbols.popFrame();
            bl = bl && symbols.eval("a") == 1.0;
            symbols = new Symbols();
            symbols.pushFrame();
            symbols.add(Symbol.makeArg("base", 0));
            symbols.add(Symbol.makeArg("x", 1));
            bl = bl && symbols.lookupConst((String)"x").op == 39;
            symbols.pushFrame();
            bl = bl && symbols.lookupConst((String)"base").op == 38;
            bl = bl && symbols.lookupConst((String)"x").op == 39;
            symbols.popFrame();
            bl = bl && symbols.lookupConst((String)"base").op == 38;
            bl = bl && symbols.lookupConst((String)"x").op == 39;
            symbols.popFrame();
            bl = bl && symbols.lookupConst((String)"x").op == 38;
        }
        catch (SyntaxException syntaxException) {
            return false;
        }
        return bl;
    }

    static boolean equal(Complex complex, Complex complex2) {
        return UnitTest.equal(complex.re, complex2.re) && UnitTest.equal(complex.im, complex2.im);
    }

    static boolean equal(double d, Complex complex) {
        return UnitTest.equal(d, complex.re) && (UnitTest.equal(0.0, complex.im) || Double.isNaN(d) && Double.isNaN(complex.im));
    }

    static boolean equal(double d, double d2) {
        return d == d2 || Double.isNaN(d) && Double.isNaN(d2) || Math.abs((d - d2) / d2) < 1.0E-15 || Math.abs(d - d2) < 1.0E-15;
    }

    static void check(double d, double d2) {
        ++checkCounter;
        if (!UnitTest.equal(d, d2)) {
            allOk = false;
            System.out.println("failed check #" + checkCounter + ": expected " + d2 + " got " + d);
        }
    }

    static void check(Complex complex, Complex complex2) {
        ++checkCounter;
        if (!UnitTest.equal(complex.re, complex2.re) || !UnitTest.equal(complex.im, complex2.im)) {
            allOk = false;
            System.out.println("failed check #" + checkCounter + ": expected " + complex2 + " got " + complex);
        }
    }

    static void check(boolean bl) {
        ++checkCounter;
        if (!bl) {
            allOk = false;
        }
    }

    static boolean testRecursiveEval() {
        Symbols symbols = new Symbols();
        symbols.define("myfun", new MyFun());
        try {
            Function function = symbols.compile("1+myfun(x)");
            return function.eval(0.0) == 2.0 && function.eval(1.0) == 1.0 && function.eval(2.0) == 0.0 && function.eval(3.0) == -1.0;
        }
        catch (SyntaxException syntaxException) {
            System.out.println("" + syntaxException);
            allOk = false;
            return false;
        }
    }
}

