/*
 * Decompiled with CFR 0.152.
 */
package org.javia.arity;

class Token {
    static final int PREFIX = 1;
    static final int LEFT = 2;
    static final int RIGHT = 3;
    static final int SUFIX = 4;
    final int priority;
    final int assoc;
    final int id;
    final byte vmop;
    double value;
    String name = null;
    int arity;
    int position;

    Token(int n, int n2, int n3, int n4) {
        this.id = n;
        this.priority = n2;
        this.assoc = n3;
        this.vmop = (byte)n4;
        this.arity = n == 11 ? 1 : -3;
    }

    Token setPos(int n) {
        this.position = n;
        return this;
    }

    Token setValue(double d) {
        this.value = d;
        return this;
    }

    Token setAlpha(String string) {
        this.name = string;
        return this;
    }

    public boolean isDerivative() {
        int n;
        return this.name != null && (n = this.name.length()) > 0 && this.name.charAt(n - 1) == '\'';
    }

    public String toString() {
        switch (this.id) {
            case 9: {
                return "" + this.value;
            }
            case 11: {
                return this.name + '(' + this.arity + ')';
            }
            case 10: {
                return this.name;
            }
        }
        return "" + this.id;
    }
}

