/*
 * Decompiled with CFR 0.152.
 */
package org.javia.arity;

import org.javia.arity.Function;
import org.javia.arity.VM;

public class Symbol {
    static final int CONST_ARITY = -3;
    private String name;
    private int arity;
    byte op;
    Function fun;
    double valueRe;
    double valueIm;
    boolean isConst = false;

    private Symbol(String string, int n, byte by, boolean bl, int n2) {
        this.setKey(string, n);
        this.op = by;
        this.isConst = bl;
    }

    Symbol(String string, Function function) {
        this.setKey(string, function.arity());
        this.fun = function;
    }

    Symbol(String string, double d, boolean bl) {
        this(string, d, 0.0, bl);
    }

    Symbol(String string, double d, double d2, boolean bl) {
        this.setKey(string, -3);
        this.valueRe = d;
        this.valueIm = d2;
        this.isConst = bl;
    }

    static Symbol makeArg(String string, int n) {
        return new Symbol(string, -3, (byte)(38 + n), false, 0);
    }

    static Symbol makeVmOp(String string, int n) {
        return new Symbol(string, VM.arity[n], (byte)n, true, 0);
    }

    public String toString() {
        return "Symbol '" + this.name + "' arity " + this.arity + " val " + this.valueRe + " op " + this.op;
    }

    public String getName() {
        return this.name;
    }

    public int getArity() {
        return this.arity == -3 ? 0 : this.arity;
    }

    static Symbol newEmpty(Symbol symbol) {
        return new Symbol(symbol.name, symbol.arity, 0, false, 0);
    }

    boolean isEmpty() {
        return this.op == 0 && this.fun == null && this.valueRe == 0.0 && this.valueIm == 0.0;
    }

    Symbol setKey(String string, int n) {
        this.name = string;
        this.arity = n;
        return this;
    }

    public boolean equals(Object object) {
        Symbol symbol = (Symbol)object;
        return this.name.equals(symbol.name) && this.arity == symbol.arity;
    }

    public int hashCode() {
        return this.name.hashCode() + this.arity;
    }
}

