/*
 * Decompiled with CFR 0.152.
 */
package org.javia.arity;

import org.javia.arity.ByteStack;
import org.javia.arity.CompiledFunction;
import org.javia.arity.DoubleStack;
import org.javia.arity.FunctionStack;
import org.javia.arity.Symbol;
import org.javia.arity.Symbols;
import org.javia.arity.SyntaxException;
import org.javia.arity.Token;
import org.javia.arity.TokenConsumer;

class SimpleCodeGen
extends TokenConsumer {
    static final SyntaxException HAS_ARGUMENTS = new SyntaxException();
    ByteStack code = new ByteStack();
    DoubleStack consts = new DoubleStack();
    FunctionStack funcs = new FunctionStack();
    Symbols symbols;
    SyntaxException exception;

    SimpleCodeGen(SyntaxException syntaxException) {
        this.exception = syntaxException;
    }

    SimpleCodeGen setSymbols(Symbols symbols) {
        this.symbols = symbols;
        return this;
    }

    void start() {
        this.code.clear();
        this.consts.clear();
        this.funcs.clear();
    }

    Symbol getSymbol(Token token) throws SyntaxException {
        Symbol symbol;
        String string = token.name;
        boolean bl = token.isDerivative();
        if (bl) {
            if (token.arity == 1) {
                string = string.substring(0, string.length() - 1);
            } else {
                throw this.exception.set("Derivative expects arity 1 but found " + token.arity, token.position);
            }
        }
        if ((symbol = this.symbols.lookup(string, token.arity)) == null) {
            throw this.exception.set("undefined '" + string + "' with arity " + token.arity, token.position);
        }
        if (bl && symbol.op > 0 && symbol.fun == null) {
            symbol.fun = CompiledFunction.makeOpFunction(symbol.op);
        }
        if (bl && symbol.fun == null) {
            throw this.exception.set("Invalid derivative " + string, token.position);
        }
        return symbol;
    }

    void push(Token token) throws SyntaxException {
        int n;
        switch (token.id) {
            case 9: {
                n = 1;
                this.consts.push(token.value, 0.0);
                break;
            }
            case 10: 
            case 11: {
                Symbol symbol = this.getSymbol(token);
                if (token.isDerivative()) {
                    n = 2;
                    this.funcs.push(symbol.fun.getDerivative());
                    break;
                }
                if (symbol.op > 0) {
                    n = symbol.op;
                    if (n < 38 || n > 42) break;
                    throw HAS_ARGUMENTS.set("eval() on implicit function", this.exception.position);
                }
                if (symbol.fun != null) {
                    n = 2;
                    this.funcs.push(symbol.fun);
                    break;
                }
                n = 1;
                this.consts.push(symbol.valueRe, symbol.valueIm);
                break;
            }
            default: {
                n = token.vmop;
                if (n > 0) break;
                throw new Error("wrong vmop: " + n + ", id " + token.id + " in \"" + this.exception.expression + '\"');
            }
        }
        this.code.push((byte)n);
    }

    CompiledFunction getFun() {
        return new CompiledFunction(0, this.code.toArray(), this.consts.getRe(), this.consts.getIm(), this.funcs.toArray());
    }
}

