/*
 * Decompiled with CFR 0.152.
 */
package org.javia.arity;

import java.util.Stack;
import org.javia.arity.Lexer;
import org.javia.arity.SyntaxException;
import org.javia.arity.Token;
import org.javia.arity.TokenConsumer;

class RPN
extends TokenConsumer {
    Stack stack = new Stack();
    int prevTokenId = 0;
    TokenConsumer consumer;
    SyntaxException exception;

    RPN(SyntaxException syntaxException) {
        this.exception = syntaxException;
    }

    void setConsumer(TokenConsumer tokenConsumer) {
        this.consumer = tokenConsumer;
    }

    void start() {
        this.stack.removeAllElements();
        this.prevTokenId = 0;
        this.consumer.start();
    }

    private Token top() {
        return this.stack.empty() ? null : (Token)this.stack.peek();
    }

    private void popHigher(int n) throws SyntaxException {
        Token token = this.top();
        while (token != null && token.priority >= n) {
            this.consumer.push(token);
            this.stack.pop();
            token = this.top();
        }
    }

    static final boolean isOperand(int n) {
        return n == 8 || n == 14 || n == 9 || n == 10 || n == 17;
    }

    void push(Token token) throws SyntaxException {
        int n = token.priority;
        int n2 = token.id;
        switch (n2) {
            case 9: 
            case 10: {
                if (RPN.isOperand(this.prevTokenId)) {
                    this.push(Lexer.TOK_MUL);
                }
                this.consumer.push(token);
                break;
            }
            case 14: {
                if (this.prevTokenId == 11) {
                    --this.top().arity;
                } else if (!RPN.isOperand(this.prevTokenId)) {
                    throw this.exception.set("unexpected ) or END", token.position);
                }
                this.popHigher(n);
                Token token2 = this.top();
                if (token2 == null) break;
                if (token2.id == 11) {
                    this.consumer.push(token2);
                } else if (token2 != Lexer.TOK_LPAREN) {
                    throw this.exception.set("expected LPAREN or CALL", token.position);
                }
                this.stack.pop();
                break;
            }
            case 12: {
                if (!RPN.isOperand(this.prevTokenId)) {
                    throw this.exception.set("misplaced COMMA", token.position);
                }
                this.popHigher(n);
                Token token3 = this.top();
                if (token3 == null || token3.id != 11) {
                    throw this.exception.set("COMMA not inside CALL", token.position);
                }
                ++token3.arity;
                break;
            }
            case 15: {
                Token token4 = Lexer.TOK_RPAREN;
                token4.position = token.position;
                do {
                    this.push(token4);
                } while (this.top() != null);
                break;
            }
            default: {
                if (token.assoc == 1) {
                    if (RPN.isOperand(this.prevTokenId)) {
                        this.push(Lexer.TOK_MUL);
                    }
                    this.stack.push(token);
                    break;
                }
                if (!RPN.isOperand(this.prevTokenId)) {
                    if (n2 == 2) {
                        token = Lexer.TOK_UMIN;
                        this.stack.push(token);
                        break;
                    }
                    if (n2 == 1) {
                        return;
                    }
                    throw this.exception.set("operator without operand", token.position);
                }
                this.popHigher(n + (token.assoc == 3 ? 1 : 0));
                this.stack.push(token);
            }
        }
        this.prevTokenId = token.id;
    }
}

