/*
 * Copyright (C) 2009 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.view.cts;

import android.test.AndroidTestCase;
import android.view.Surface;
import android.view.Surface.OutOfResourcesException;
import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargets;

@TestTargetClass(OutOfResourcesException.class)
public class Surface_OutOfResourcesExceptionTest extends AndroidTestCase {
    private static final String NAME = "Test_Surface_OutOfResourcesException";

    @TestTargets({
        @TestTargetNew(
            level = TestLevel.COMPLETE,
            method = "Surface.OutOfResourcesException",
            args = {}
        ),
        @TestTargetNew(
            level = TestLevel.COMPLETE,
            method = "Surface.OutOfResourcesException",
            args = {java.lang.String.class}
        )
    })
    public void testConstructor() {
        new Surface.OutOfResourcesException();
        new Surface.OutOfResourcesException(NAME);
    }
}
