/*
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef bts_FLT16MAT3D_EM_H
#define bts_FLT16MAT3D_EM_H

/* ---- includes ----------------------------------------------------------- */

#include "b_BasicEm/Context.h"
#include "b_BasicEm/Basic.h"
#include "b_BasicEm/Phase.h"
#include "b_TensorEm/Int16Vec3D.h"
#include "b_TensorEm/Flt16Vec3D.h"

/* ---- related objects  --------------------------------------------------- */

/* ---- typedefs ----------------------------------------------------------- */

/* ---- constants ---------------------------------------------------------- */

/* ---- object definition -------------------------------------------------- */

/** 3d matrix with floating point */
struct bts_Flt16Mat3D 
{

	/* ---- private data --------------------------------------------------- */

	/* ---- public data ---------------------------------------------------- */

	/** xx component */
	int16 xxE;

	/** xy component */
	int16 xyE;

	/** xz component */
	int16 xzE;

	/** yx component */
	int16 yxE;

	/** yy component */
	int16 yyE;

	/** yz component */
	int16 yzE;

	/** zx component */
	int16 zxE;

	/** zy component */
	int16 zyE;

	/** zz component */
	int16 zzE;

	/** point position */
	int16 bbpE;
};

/* ---- associated objects ------------------------------------------------- */

/* ---- external functions ------------------------------------------------- */

/* ---- \ghd{ constructor/destructor } ------------------------------------- */

/** initializes matrix */
void bts_Flt16Mat3D_init( struct bts_Flt16Mat3D* ptrA );

/** destroys matrix */
void bts_Flt16Mat3D_exit( struct bts_Flt16Mat3D* ptrA );

/* ---- \ghd{ operators } -------------------------------------------------- */

/* ---- \ghd{ query functions } -------------------------------------------- */

/* ---- \ghd{ modify functions } ------------------------------------------- */

/* ---- \ghd{ memory I/O } ------------------------------------------------- */

/** size object needs when written to memory */
uint32 bts_Flt16Mat3D_memSize( struct bbs_Context* cpA,
							   const struct bts_Flt16Mat3D* ptrA );

/** writes object to memory; returns number of bytes written */
uint32 bts_Flt16Mat3D_memWrite( struct bbs_Context* cpA,
							    const struct bts_Flt16Mat3D* ptrA, 
								uint16* memPtrA );

/** reads object from memory; returns number of bytes read */
uint32 bts_Flt16Mat3D_memRead( struct bbs_Context* cpA,
							   struct bts_Flt16Mat3D* ptrA, 
							   const uint16* memPtrA );

/* ---- \ghd{ exec functions } --------------------------------------------- */

/** creates identity matrix */
struct bts_Flt16Mat3D bts_Flt16Mat3D_createIdentity( void );

/** creates scale matrix */
struct bts_Flt16Mat3D bts_Flt16Mat3D_createScale( int32 scaleA, int32 scaleBbpA );

/** creates matrix from 16 bit values */
struct bts_Flt16Mat3D bts_Flt16Mat3D_create16( int16 xxA, int16 xyA, int16 xzA,
											   int16 yxA, int16 yyA, int16 yzA,
											   int16 zxA, int16 zyA, int16 zzA,
											   int16 bbpA );

/** creates matrix from 32 bit values (automatic adjustment of bbp value) */
struct bts_Flt16Mat3D bts_Flt16Mat3D_create32( int32 xxA, int32 xyA, int32 xzA,
											   int32 yxA, int32 yyA, int32 yzA,
											   int32 zxA, int32 zyA, int32 zzA,
											   int32 bbpA );

/** scales matrix by a factor */
void bts_Flt16Mat3D_scale( struct bts_Flt16Mat3D* ptrA, int32 scaleA, int32 scaleBbpA );

/** multiplies matrix with vecA; returns resulting vector */
#ifndef HW_EE /* causes internal compiler error in ee-gcc */
struct bts_Int16Vec3D bts_Flt16Mat3D_map( const struct bts_Flt16Mat3D* matPtrA, 
								          const struct bts_Int16Vec3D* vecPtrA );
#endif
/** Multiplies matrix with float vecA; returns resulting vector. 
 *  The point position of returned vector is the same as of the input vector.
 */
struct bts_Flt16Vec3D bts_Flt16Mat3D_mapFlt( const struct bts_Flt16Mat3D* matPtrA, 
								             const struct bts_Flt16Vec3D* vecPtrA );

/** multiplies matrix with matA; returns resulting matrix */
struct bts_Flt16Mat3D bts_Flt16Mat3D_mul( const struct bts_Flt16Mat3D* mat1PtrA, 
								          const struct bts_Flt16Mat3D* mat2PtrA );

/** multiplies matrix with matA; returns pointer to resulting matrix */
struct bts_Flt16Mat3D* bts_Flt16Mat3D_mulTo( struct bts_Flt16Mat3D* mat1PtrA, 
				                             const struct bts_Flt16Mat3D* mat2PtrA );

#endif /* bts_FLT16MAT3D_EM_H */

