/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package galatea.relaxer.vxml20;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>VxmlPrompt</b> is generated from vxml20.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="prompt">
 *       <optional>
 *         <attribute name="bargein">
 *           <choice>
 *             <value type="NMTOKEN">true</value>
 *             <value type="NMTOKEN">false</value>
 *           </choice>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="bargeintype">
 *           <choice>
 *             <value type="NMTOKEN">speech</value>
 *             <value type="NMTOKEN">hotword</value>
 *           </choice>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="cond">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="count">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="lang">
 *           <data type="NMTOKEN"/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="timeout">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <mixed>
 *         <zeroOrMore>
 *           <choice>
 *             <ref name="audio"/>
 *             <ref name="prosody"/>
 *             <ref name="voice"/>
 *             <ref name="emotion"/>
 *             <ref name="CONTEXT"/>
 *             <ref name="REGWORD"/>
 *             <ref name="VOICE"/>
 *             <ref name="PITCH"/>
 *             <ref name="break"/>
 *             <ref name="phoneme"/>
 *             <ref name="say-as"/>
 *             <ref name="paragraph"/>
 *             <ref name="p"/>
 *             <ref name="sentence"/>
 *             <ref name="s"/>
 *             <ref name="LANG"/>
 *             <ref name="PARTOFSP"/>
 *             <ref name="PRON"/>
 *             <ref name="RATE"/>
 *             <ref name="VOLUME"/>
 *             <ref name="enumerate"/>
 *             <ref name="value"/>
 *             <ref name="emphasis"/>
 *             <ref name="mark"/>
 *             <ref name="BOOKMARK"/>
 *             <ref name="EMPH"/>
 *             <ref name="SPELL"/>
 *             <ref name="SILENCE"/>
 *             <ref name="SPEECH"/>
 *             <ref name="RESET"/>
 *             <ref name="native"/>
 *             <ref name="all-of"/>
 *             <ref name="log"/>
 *           </choice>
 *         </zeroOrMore>
 *       </mixed>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="prompt"&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="bargein"&gt;
 *           &lt;choice&gt;
 *             &lt;value type="NMTOKEN"&gt;true&lt;/value&gt;
 *             &lt;value type="NMTOKEN"&gt;false&lt;/value&gt;
 *           &lt;/choice&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="bargeintype"&gt;
 *           &lt;choice&gt;
 *             &lt;value type="NMTOKEN"&gt;speech&lt;/value&gt;
 *             &lt;value type="NMTOKEN"&gt;hotword&lt;/value&gt;
 *           &lt;/choice&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="cond"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="count"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="lang"&gt;
 *           &lt;data type="NMTOKEN"/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="timeout"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;mixed&gt;
 *         &lt;zeroOrMore&gt;
 *           &lt;choice&gt;
 *             &lt;ref name="audio"/&gt;
 *             &lt;ref name="prosody"/&gt;
 *             &lt;ref name="voice"/&gt;
 *             &lt;ref name="emotion"/&gt;
 *             &lt;ref name="CONTEXT"/&gt;
 *             &lt;ref name="REGWORD"/&gt;
 *             &lt;ref name="VOICE"/&gt;
 *             &lt;ref name="PITCH"/&gt;
 *             &lt;ref name="break"/&gt;
 *             &lt;ref name="phoneme"/&gt;
 *             &lt;ref name="say-as"/&gt;
 *             &lt;ref name="paragraph"/&gt;
 *             &lt;ref name="p"/&gt;
 *             &lt;ref name="sentence"/&gt;
 *             &lt;ref name="s"/&gt;
 *             &lt;ref name="LANG"/&gt;
 *             &lt;ref name="PARTOFSP"/&gt;
 *             &lt;ref name="PRON"/&gt;
 *             &lt;ref name="RATE"/&gt;
 *             &lt;ref name="VOLUME"/&gt;
 *             &lt;ref name="enumerate"/&gt;
 *             &lt;ref name="value"/&gt;
 *             &lt;ref name="emphasis"/&gt;
 *             &lt;ref name="mark"/&gt;
 *             &lt;ref name="BOOKMARK"/&gt;
 *             &lt;ref name="EMPH"/&gt;
 *             &lt;ref name="SPELL"/&gt;
 *             &lt;ref name="SILENCE"/&gt;
 *             &lt;ref name="SPEECH"/&gt;
 *             &lt;ref name="RESET"/&gt;
 *             &lt;ref name="native"/&gt;
 *             &lt;ref name="all-of"/&gt;
 *             &lt;ref name="log"/&gt;
 *           &lt;/choice&gt;
 *         &lt;/zeroOrMore&gt;
 *       &lt;/mixed&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version vxml20.rng (Thu Oct 02 00:02:04 JST 2008)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class VxmlPrompt implements java.io.Serializable, Cloneable, IRNSContainer, IRVisitable, IRNode, IVxmlMenuMixed, IVxmlMenuMixedChoice, IVxmlCatchMixed, IVxmlCatchMixedChoice, IVxmlIfMixed, IVxmlIfMixedChoice, IVxmlNoinputMixed, IVxmlNoinputMixedChoice, IVxmlHelpMixed, IVxmlHelpMixedChoice, IVxmlNomatchMixed, IVxmlNomatchMixedChoice, IVxmlErrorMixed, IVxmlErrorMixedChoice, IVxmlObjectMixed, IVxmlObjectMixedChoice, IVxmlFilledMixed, IVxmlFilledMixedChoice, IVxmlSubdialogMixed, IVxmlSubdialogMixedChoice, IVxmlRecordMixed, IVxmlRecordMixedChoice, IVxmlTransferMixed, IVxmlTransferMixedChoice, IVxmlFieldMixed, IVxmlFieldMixedChoice, IVxmlInitialMixed, IVxmlInitialMixedChoice, IVxmlBlockMixed, IVxmlBlockMixedChoice {
    public static final String BARGEIN_TRUE = "true";
    public static final String BARGEIN_FALSE = "false";
    public static final String BARGEINTYPE_SPEECH = "speech";
    public static final String BARGEINTYPE_HOTWORD = "hotword";

    private RNSContext rNSContext_ = new RNSContext(this, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
    private String bargein_;
    private String bargeintype_;
    private String cond_;
    private String count_;
    private String lang_;
    private String timeout_;
    // List<IVxmlPromptMixed>
    private java.util.List content_ = new java.util.ArrayList();
    private Element xmlElement;
    private IRNode parentRNode_;

    /**
     * Creates a <code>VxmlPrompt</code>.
     *
     */
    public VxmlPrompt() {
    }

    /**
     * Creates a <code>VxmlPrompt</code>.
     *
     * @param source
     */
    public VxmlPrompt(VxmlPrompt source) {
        setup(source);
    }

    /**
     * Creates a <code>VxmlPrompt</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public VxmlPrompt(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>VxmlPrompt</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public VxmlPrompt(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>VxmlPrompt</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public VxmlPrompt(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>VxmlPrompt</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlPrompt(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>VxmlPrompt</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlPrompt(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>VxmlPrompt</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlPrompt(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>VxmlPrompt</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlPrompt(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>VxmlPrompt</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlPrompt(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>VxmlPrompt</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlPrompt(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>VxmlPrompt</code> by the VxmlPrompt <code>source</code>.
     *
     * @param source
     */
    public void setup(VxmlPrompt source) {
        int size;
        bargein_ = source.bargein_;
        bargeintype_ = source.bargeintype_;
        cond_ = source.cond_;
        count_ = source.count_;
        lang_ = source.lang_;
        timeout_ = source.timeout_;
        this.content_.clear();
        size = source.content_.size();
        for (int i = 0;i < size;i++) {
            addContent((IVxmlPromptMixed)source.getContent(i).clone());
        }
    }

    /**
     * Initializes the <code>VxmlPrompt</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>VxmlPrompt</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>VxmlPrompt</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        xmlElement = element;
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        bargein_ = URelaxer.getAttributePropertyAsString(element, "bargein");
        bargeintype_ = URelaxer.getAttributePropertyAsString(element, "bargeintype");
        cond_ = URelaxer.getAttributePropertyAsString(element, "cond");
        count_ = URelaxer.getAttributePropertyAsString(element, "count");
        lang_ = URelaxer.getAttributePropertyAsString(element, "lang");
        timeout_ = URelaxer.getAttributePropertyAsString(element, "timeout");
        this.content_.clear();
        while (true) {
            if (RString.isMatch(stack)) {
                addContent(new RString(stack));
            } else if (VxmlAudio.isMatch(stack)) {
                addContent(new VxmlAudio(stack));
            } else if (VxmlProsody.isMatch(stack)) {
                addContent(new VxmlProsody(stack));
            } else if (VxmlVoice.isMatch(stack)) {
                addContent(new VxmlVoice(stack));
            } else if (VxmlEmotion.isMatch(stack)) {
                addContent(new VxmlEmotion(stack));
            } else if (VxmlREGWORD.isMatch(stack)) {
                addContent(new VxmlREGWORD(stack));
            } else if (VxmlCONTEXT.isMatch(stack)) {
                addContent(new VxmlCONTEXT(stack));
            } else if (VxmlJVOICE.isMatch(stack)) {
                addContent(new VxmlJVOICE(stack));
            } else if (VxmlPITCH.isMatch(stack)) {
                addContent(new VxmlPITCH(stack));
            } else if (VxmlNative.isMatch(stack)) {
                addContent(new VxmlNative(stack));
            } else if (VxmlBreak.isMatch(stack)) {
                addContent(new VxmlBreak(stack));
            } else if (VxmlPhoneme.isMatch(stack)) {
                addContent(new VxmlPhoneme(stack));
            } else if (VxmlSayAs.isMatch(stack)) {
                addContent(new VxmlSayAs(stack));
            } else if (VxmlParagraph.isMatch(stack)) {
                addContent(new VxmlParagraph(stack));
            } else if (VxmlP.isMatch(stack)) {
                addContent(new VxmlP(stack));
            } else if (VxmlSentence.isMatch(stack)) {
                addContent(new VxmlSentence(stack));
            } else if (VxmlS.isMatch(stack)) {
                addContent(new VxmlS(stack));
            } else if (VxmlLANG.isMatch(stack)) {
                addContent(new VxmlLANG(stack));
            } else if (VxmlPRON.isMatch(stack)) {
                addContent(new VxmlPRON(stack));
            } else if (VxmlRATE.isMatch(stack)) {
                addContent(new VxmlRATE(stack));
            } else if (VxmlEmphasis.isMatch(stack)) {
                addContent(new VxmlEmphasis(stack));
            } else if (VxmlLog.isMatch(stack)) {
                addContent(new VxmlLog(stack));
            } else if (VxmlPARTOFSP.isMatch(stack)) {
                addContent(new VxmlPARTOFSP(stack));
            } else if (VxmlVOLUME.isMatch(stack)) {
                addContent(new VxmlVOLUME(stack));
            } else if (VxmlEnumerate.isMatch(stack)) {
                addContent(new VxmlEnumerate(stack));
            } else if (VxmlValue.isMatch(stack)) {
                addContent(new VxmlValue(stack));
            } else if (VxmlMark.isMatch(stack)) {
                addContent(new VxmlMark(stack));
            } else if (VxmlBOOKMARK.isMatch(stack)) {
                addContent(new VxmlBOOKMARK(stack));
            } else if (VxmlSPELL.isMatch(stack)) {
                addContent(new VxmlSPELL(stack));
            } else if (VxmlSILENCE.isMatch(stack)) {
                addContent(new VxmlSILENCE(stack));
            } else if (VxmlSPEECH.isMatch(stack)) {
                addContent(new VxmlSPEECH(stack));
            } else if (VxmlEMPH.isMatch(stack)) {
                addContent(new VxmlEMPH(stack));
            } else if (VxmlRESET.isMatch(stack)) {
                addContent(new VxmlRESET(stack));
            } else if (VxmlAllOf.isMatch(stack)) {
                addContent(new VxmlAllOf(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new VxmlPrompt((VxmlPrompt)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "prompt");
        rNSContext_.setupNamespace(element);
        int size;
        if (this.bargein_ != null) {
            URelaxer.setAttributePropertyByString(element, "bargein", this.bargein_);
        }
        if (this.bargeintype_ != null) {
            URelaxer.setAttributePropertyByString(element, "bargeintype", this.bargeintype_);
        }
        if (this.cond_ != null) {
            URelaxer.setAttributePropertyByString(element, "cond", this.cond_);
        }
        if (this.count_ != null) {
            URelaxer.setAttributePropertyByString(element, "count", this.count_);
        }
        if (this.lang_ != null) {
            URelaxer.setAttributePropertyByString(element, "lang", this.lang_);
        }
        if (this.timeout_ != null) {
            URelaxer.setAttributePropertyByString(element, "timeout", this.timeout_);
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlPromptMixed value = (IVxmlPromptMixed)this.content_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>VxmlPrompt</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>VxmlPrompt</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlPrompt</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlPrompt</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlPrompt</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlPrompt</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Sets a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void setContent(String value) {
        setContent(new RString(value));
    }

    /**
     * Adds a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void addContent(String value) {
        addContent(new RString(value));
    }

    /**
     * Sets a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void setContentByString(String value) {
        setContent(new RString(value));
    }

    /**
     * Adds a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void addContentByString(String value) {
        addContent(new RString(value));
    }

    /**
     * Sets a mixed content by <code>org.w3c.dom.Node</code>.
     *
     * @param value
     */
    public void setContent(org.w3c.dom.Node value) {
        setContent(new RString(value));
    }

    /**
     * Adds a mixed content by <code>org.w3c.dom.Node</code>.
     *
     * @param value
     */
    public void addContent(org.w3c.dom.Node value) {
        addContent(new RString(value));
    }

    /**
     * Gets the RNSContext property <b>RNSContext</b>.
     *
     * @return RNSContext
     */
    public RNSContext rGetRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>RNSContext</b>.
     *
     * @param rNSContext
     */
    public void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the String property <b>bargein</b>.
     *
     * @return String
     */
    public String getBargein() {
        return (bargein_);
    }

    /**
     * Sets the String property <b>bargein</b>.
     *
     * @param bargein
     */
    public void setBargein(String bargein) {
        this.bargein_ = bargein;
    }

    /**
     * Gets the String property <b>bargeintype</b>.
     *
     * @return String
     */
    public String getBargeintype() {
        return (bargeintype_);
    }

    /**
     * Sets the String property <b>bargeintype</b>.
     *
     * @param bargeintype
     */
    public void setBargeintype(String bargeintype) {
        this.bargeintype_ = bargeintype;
    }

    /**
     * Gets the String property <b>cond</b>.
     *
     * @return String
     */
    public String getCond() {
        return (cond_);
    }

    /**
     * Sets the String property <b>cond</b>.
     *
     * @param cond
     */
    public void setCond(String cond) {
        this.cond_ = cond;
    }

    /**
     * Gets the String property <b>count</b>.
     *
     * @return String
     */
    public String getCount() {
        return (count_);
    }

    /**
     * Sets the String property <b>count</b>.
     *
     * @param count
     */
    public void setCount(String count) {
        this.count_ = count;
    }

    /**
     * Gets the String property <b>lang</b>.
     *
     * @return String
     */
    public String getLang() {
        return (lang_);
    }

    /**
     * Sets the String property <b>lang</b>.
     *
     * @param lang
     */
    public void setLang(String lang) {
        this.lang_ = lang;
    }

    /**
     * Gets the String property <b>timeout</b>.
     *
     * @return String
     */
    public String getTimeout() {
        return (timeout_);
    }

    /**
     * Sets the String property <b>timeout</b>.
     *
     * @param timeout
     */
    public void setTimeout(String timeout) {
        this.timeout_ = timeout;
    }

    /**
     * Gets the IVxmlPromptMixed property <b>content</b>.
     *
     * @return IVxmlPromptMixed[]
     */
    public IVxmlPromptMixed[] getContent() {
        IVxmlPromptMixed[] array = new IVxmlPromptMixed[content_.size()];
        return ((IVxmlPromptMixed[])content_.toArray(array));
    }

    /**
     * Sets the IVxmlPromptMixed property <b>content</b>.
     *
     * @param content
     */
    public void setContent(IVxmlPromptMixed[] content) {
        this.content_.clear();
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Sets the IVxmlPromptMixed property <b>content</b>.
     *
     * @param content
     */
    public void setContent(IVxmlPromptMixed content) {
        this.content_.clear();
        addContent(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlPromptMixed property <b>content</b>.
     *
     * @param content
     */
    public void addContent(IVxmlPromptMixed content) {
        this.content_.add(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlPromptMixed property <b>content</b>.
     *
     * @param content
     */
    public void addContent(IVxmlPromptMixed[] content) {
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Gets number of the IVxmlPromptMixed property <b>content</b>.
     *
     * @return int
     */
    public int sizeContent() {
        return (content_.size());
    }

    /**
     * Gets the IVxmlPromptMixed property <b>content</b> by index.
     *
     * @param index
     * @return IVxmlPromptMixed
     */
    public IVxmlPromptMixed getContent(int index) {
        return ((IVxmlPromptMixed)content_.get(index));
    }

    /**
     * Sets the IVxmlPromptMixed property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public void setContent(int index, IVxmlPromptMixed content) {
        this.content_.set(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlPromptMixed property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public void addContent(int index, IVxmlPromptMixed content) {
        this.content_.add(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Remove the IVxmlPromptMixed property <b>content</b> by index.
     *
     * @param index
     */
    public void removeContent(int index) {
        this.content_.remove(index);
    }

    /**
     * Remove the IVxmlPromptMixed property <b>content</b> by object.
     *
     * @param content
     */
    public void removeContent(IVxmlPromptMixed content) {
        this.content_.remove(content);
    }

    /**
     * Clear the IVxmlPromptMixed property <b>content</b>.
     *
     */
    public void clearContent() {
        this.content_.clear();
    }

    /**
     * Gets the element to be used in the object construction.
     *
     * @return Element
     */
    public Element rGetElement() {
        return (xmlElement);
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.append("<");
        URelaxer.makeQName(prefix, "prompt", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (bargein_ != null) {
            buffer.append(" ");
            buffer.append("bargein");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getBargein())));
            buffer.append("\"");
        }
        if (bargeintype_ != null) {
            buffer.append(" ");
            buffer.append("bargeintype");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getBargeintype())));
            buffer.append("\"");
        }
        if (cond_ != null) {
            buffer.append(" ");
            buffer.append("cond");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getCond())));
            buffer.append("\"");
        }
        if (count_ != null) {
            buffer.append(" ");
            buffer.append("count");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getCount())));
            buffer.append("\"");
        }
        if (lang_ != null) {
            buffer.append(" ");
            buffer.append("lang");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getLang())));
            buffer.append("\"");
        }
        if (timeout_ != null) {
            buffer.append(" ");
            buffer.append("timeout");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getTimeout())));
            buffer.append("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlPromptMixed value = (IVxmlPromptMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.append(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlPromptMixed value = (IVxmlPromptMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "prompt", buffer);
        buffer.append(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.write("<");
        URelaxer.makeQName(prefix, "prompt", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (bargein_ != null) {
            buffer.write(" ");
            buffer.write("bargein");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getBargein())));
            buffer.write("\"");
        }
        if (bargeintype_ != null) {
            buffer.write(" ");
            buffer.write("bargeintype");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getBargeintype())));
            buffer.write("\"");
        }
        if (cond_ != null) {
            buffer.write(" ");
            buffer.write("cond");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getCond())));
            buffer.write("\"");
        }
        if (count_ != null) {
            buffer.write(" ");
            buffer.write("count");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getCount())));
            buffer.write("\"");
        }
        if (lang_ != null) {
            buffer.write(" ");
            buffer.write("lang");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getLang())));
            buffer.write("\"");
        }
        if (timeout_ != null) {
            buffer.write(" ");
            buffer.write("timeout");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getTimeout())));
            buffer.write("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlPromptMixed value = (IVxmlPromptMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.write(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlPromptMixed value = (IVxmlPromptMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</");
        URelaxer.makeQName(prefix, "prompt", buffer);
        buffer.write(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.print("<");
        URelaxer.makeQName(prefix, "prompt", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (bargein_ != null) {
            buffer.print(" ");
            buffer.print("bargein");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getBargein())));
            buffer.print("\"");
        }
        if (bargeintype_ != null) {
            buffer.print(" ");
            buffer.print("bargeintype");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getBargeintype())));
            buffer.print("\"");
        }
        if (cond_ != null) {
            buffer.print(" ");
            buffer.print("cond");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getCond())));
            buffer.print("\"");
        }
        if (count_ != null) {
            buffer.print(" ");
            buffer.print("count");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getCount())));
            buffer.print("\"");
        }
        if (lang_ != null) {
            buffer.print(" ");
            buffer.print("lang");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getLang())));
            buffer.print("\"");
        }
        if (timeout_ != null) {
            buffer.print(" ");
            buffer.print("timeout");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getTimeout())));
            buffer.print("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlPromptMixed value = (IVxmlPromptMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.print(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlPromptMixed value = (IVxmlPromptMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "prompt", buffer);
        buffer.print(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getBargeinAsString() {
        return (URelaxer.getString(getBargein()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getBargeintypeAsString() {
        return (URelaxer.getString(getBargeintype()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getCondAsString() {
        return (URelaxer.getString(getCond()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getCountAsString() {
        return (URelaxer.getString(getCount()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getLangAsString() {
        return (URelaxer.getString(getLang()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getTimeoutAsString() {
        return (URelaxer.getString(getTimeout()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setBargeinByString(String string) {
        setBargein(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setBargeintypeByString(String string) {
        setBargeintype(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setCondByString(String string) {
        setCond(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setCountByString(String string) {
        setCount(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setLangByString(String string) {
        setLang(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setTimeoutByString(String string) {
        setTimeout(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(content_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>VxmlPrompt</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "prompt")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (RString.isMatch(target)) {
            $match$ = true;
        }
        while (true) {
            if (VxmlAudio.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlProsody.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlVoice.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEmotion.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlREGWORD.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlCONTEXT.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlJVOICE.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPITCH.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlNative.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlBreak.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPhoneme.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSayAs.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlParagraph.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlP.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSentence.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlS.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlLANG.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPRON.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlRATE.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEmphasis.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlLog.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPARTOFSP.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlVOLUME.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEnumerate.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlValue.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlMark.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlBOOKMARK.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSPELL.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSILENCE.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSPEECH.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEMPH.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlRESET.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlAllOf.isMatchHungry(target)) {
                $match$ = true;
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlPrompt</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlPrompt</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
