/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package galatea.relaxer.vxml20;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>VxmlLink</b> is generated from vxml20.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="link">
 *       <optional>
 *         <attribute name="fetchhint">
 *           <choice>
 *             <value type="NMTOKEN">prefetch</value>
 *             <value type="NMTOKEN">safe</value>
 *           </choice>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="fetchtimeout">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="maxage">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="maxstale">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="next">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="expr">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="fetchaudio">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="dtmf">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="event">
 *           <data type="NMTOKEN"/>
 *         </attribute>
 *       </optional>
 *       <zeroOrMore>
 *         <ref name="grammar"/>
 *       </zeroOrMore>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="link"&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="fetchhint"&gt;
 *           &lt;choice&gt;
 *             &lt;value type="NMTOKEN"&gt;prefetch&lt;/value&gt;
 *             &lt;value type="NMTOKEN"&gt;safe&lt;/value&gt;
 *           &lt;/choice&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="fetchtimeout"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="maxage"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="maxstale"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="next"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="expr"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="fetchaudio"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="dtmf"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="event"&gt;
 *           &lt;data type="NMTOKEN"/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;zeroOrMore&gt;
 *         &lt;ref name="grammar"/&gt;
 *       &lt;/zeroOrMore&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version vxml20.rng (Thu Oct 02 00:02:03 JST 2008)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class VxmlLink implements java.io.Serializable, Cloneable, IRNSContainer, IRVisitable, IRNode, IVxmlVxmlChoice, IVxmlFormChoice, IVxmlFieldMixed, IVxmlFieldMixedChoice, IVxmlInitialMixed, IVxmlInitialMixedChoice {
    public static final String FETCHHINT_PREFETCH = "prefetch";
    public static final String FETCHHINT_SAFE = "safe";

    private RNSContext rNSContext_ = new RNSContext(this, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
    private String fetchhint_;
    private String fetchtimeout_;
    private String maxage_;
    private String maxstale_;
    private String next_;
    private String expr_;
    private String fetchaudio_;
    private String dtmf_;
    private String event_;
    // List<VxmlGrammar>
    private java.util.List grammar_ = new java.util.ArrayList();
    private Element xmlElement;
    private IRNode parentRNode_;

    /**
     * Creates a <code>VxmlLink</code>.
     *
     */
    public VxmlLink() {
    }

    /**
     * Creates a <code>VxmlLink</code>.
     *
     * @param source
     */
    public VxmlLink(VxmlLink source) {
        setup(source);
    }

    /**
     * Creates a <code>VxmlLink</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public VxmlLink(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>VxmlLink</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public VxmlLink(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>VxmlLink</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public VxmlLink(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>VxmlLink</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlLink(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>VxmlLink</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlLink(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>VxmlLink</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlLink(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>VxmlLink</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlLink(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>VxmlLink</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlLink(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>VxmlLink</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlLink(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>VxmlLink</code> by the VxmlLink <code>source</code>.
     *
     * @param source
     */
    public void setup(VxmlLink source) {
        int size;
        fetchhint_ = source.fetchhint_;
        fetchtimeout_ = source.fetchtimeout_;
        maxage_ = source.maxage_;
        maxstale_ = source.maxstale_;
        next_ = source.next_;
        expr_ = source.expr_;
        fetchaudio_ = source.fetchaudio_;
        dtmf_ = source.dtmf_;
        event_ = source.event_;
        this.grammar_.clear();
        size = source.grammar_.size();
        for (int i = 0;i < size;i++) {
            addGrammar((VxmlGrammar)source.getGrammar(i).clone());
        }
    }

    /**
     * Initializes the <code>VxmlLink</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>VxmlLink</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>VxmlLink</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        xmlElement = element;
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        fetchhint_ = URelaxer.getAttributePropertyAsString(element, "fetchhint");
        fetchtimeout_ = URelaxer.getAttributePropertyAsString(element, "fetchtimeout");
        maxage_ = URelaxer.getAttributePropertyAsString(element, "maxage");
        maxstale_ = URelaxer.getAttributePropertyAsString(element, "maxstale");
        next_ = URelaxer.getAttributePropertyAsString(element, "next");
        expr_ = URelaxer.getAttributePropertyAsString(element, "expr");
        fetchaudio_ = URelaxer.getAttributePropertyAsString(element, "fetchaudio");
        dtmf_ = URelaxer.getAttributePropertyAsString(element, "dtmf");
        event_ = URelaxer.getAttributePropertyAsString(element, "event");
        grammar_.clear();
        while (true) {
            if (VxmlGrammar.isMatch(stack)) {
                addGrammar(new VxmlGrammar(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new VxmlLink((VxmlLink)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "link");
        rNSContext_.setupNamespace(element);
        int size;
        if (this.fetchhint_ != null) {
            URelaxer.setAttributePropertyByString(element, "fetchhint", this.fetchhint_);
        }
        if (this.fetchtimeout_ != null) {
            URelaxer.setAttributePropertyByString(element, "fetchtimeout", this.fetchtimeout_);
        }
        if (this.maxage_ != null) {
            URelaxer.setAttributePropertyByString(element, "maxage", this.maxage_);
        }
        if (this.maxstale_ != null) {
            URelaxer.setAttributePropertyByString(element, "maxstale", this.maxstale_);
        }
        if (this.next_ != null) {
            URelaxer.setAttributePropertyByString(element, "next", this.next_);
        }
        if (this.expr_ != null) {
            URelaxer.setAttributePropertyByString(element, "expr", this.expr_);
        }
        if (this.fetchaudio_ != null) {
            URelaxer.setAttributePropertyByString(element, "fetchaudio", this.fetchaudio_);
        }
        if (this.dtmf_ != null) {
            URelaxer.setAttributePropertyByString(element, "dtmf", this.dtmf_);
        }
        if (this.event_ != null) {
            URelaxer.setAttributePropertyByString(element, "event", this.event_);
        }
        size = this.grammar_.size();
        for (int i = 0;i < size;i++) {
            VxmlGrammar value = (VxmlGrammar)this.grammar_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>VxmlLink</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>VxmlLink</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlLink</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlLink</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlLink</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlLink</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the RNSContext property <b>RNSContext</b>.
     *
     * @return RNSContext
     */
    public RNSContext rGetRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>RNSContext</b>.
     *
     * @param rNSContext
     */
    public void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the String property <b>fetchhint</b>.
     *
     * @return String
     */
    public String getFetchhint() {
        return (fetchhint_);
    }

    /**
     * Sets the String property <b>fetchhint</b>.
     *
     * @param fetchhint
     */
    public void setFetchhint(String fetchhint) {
        this.fetchhint_ = fetchhint;
    }

    /**
     * Gets the String property <b>fetchtimeout</b>.
     *
     * @return String
     */
    public String getFetchtimeout() {
        return (fetchtimeout_);
    }

    /**
     * Sets the String property <b>fetchtimeout</b>.
     *
     * @param fetchtimeout
     */
    public void setFetchtimeout(String fetchtimeout) {
        this.fetchtimeout_ = fetchtimeout;
    }

    /**
     * Gets the String property <b>maxage</b>.
     *
     * @return String
     */
    public String getMaxage() {
        return (maxage_);
    }

    /**
     * Sets the String property <b>maxage</b>.
     *
     * @param maxage
     */
    public void setMaxage(String maxage) {
        this.maxage_ = maxage;
    }

    /**
     * Gets the String property <b>maxstale</b>.
     *
     * @return String
     */
    public String getMaxstale() {
        return (maxstale_);
    }

    /**
     * Sets the String property <b>maxstale</b>.
     *
     * @param maxstale
     */
    public void setMaxstale(String maxstale) {
        this.maxstale_ = maxstale;
    }

    /**
     * Gets the String property <b>next</b>.
     *
     * @return String
     */
    public String getNext() {
        return (next_);
    }

    /**
     * Sets the String property <b>next</b>.
     *
     * @param next
     */
    public void setNext(String next) {
        this.next_ = next;
    }

    /**
     * Gets the String property <b>expr</b>.
     *
     * @return String
     */
    public String getExpr() {
        return (expr_);
    }

    /**
     * Sets the String property <b>expr</b>.
     *
     * @param expr
     */
    public void setExpr(String expr) {
        this.expr_ = expr;
    }

    /**
     * Gets the String property <b>fetchaudio</b>.
     *
     * @return String
     */
    public String getFetchaudio() {
        return (fetchaudio_);
    }

    /**
     * Sets the String property <b>fetchaudio</b>.
     *
     * @param fetchaudio
     */
    public void setFetchaudio(String fetchaudio) {
        this.fetchaudio_ = fetchaudio;
    }

    /**
     * Gets the String property <b>dtmf</b>.
     *
     * @return String
     */
    public String getDtmf() {
        return (dtmf_);
    }

    /**
     * Sets the String property <b>dtmf</b>.
     *
     * @param dtmf
     */
    public void setDtmf(String dtmf) {
        this.dtmf_ = dtmf;
    }

    /**
     * Gets the String property <b>event</b>.
     *
     * @return String
     */
    public String getEvent() {
        return (event_);
    }

    /**
     * Sets the String property <b>event</b>.
     *
     * @param event
     */
    public void setEvent(String event) {
        this.event_ = event;
    }

    /**
     * Gets the VxmlGrammar property <b>grammar</b>.
     *
     * @return VxmlGrammar[]
     */
    public VxmlGrammar[] getGrammar() {
        VxmlGrammar[] array = new VxmlGrammar[grammar_.size()];
        return ((VxmlGrammar[])grammar_.toArray(array));
    }

    /**
     * Sets the VxmlGrammar property <b>grammar</b>.
     *
     * @param grammar
     */
    public void setGrammar(VxmlGrammar[] grammar) {
        this.grammar_.clear();
        for (int i = 0;i < grammar.length;i++) {
            addGrammar(grammar[i]);
        }
        for (int i = 0;i < grammar.length;i++) {
            grammar[i].rSetParentRNode(this);
        }
    }

    /**
     * Sets the VxmlGrammar property <b>grammar</b>.
     *
     * @param grammar
     */
    public void setGrammar(VxmlGrammar grammar) {
        this.grammar_.clear();
        addGrammar(grammar);
        if (grammar != null) {
            grammar.rSetParentRNode(this);
        }
    }

    /**
     * Adds the VxmlGrammar property <b>grammar</b>.
     *
     * @param grammar
     */
    public void addGrammar(VxmlGrammar grammar) {
        this.grammar_.add(grammar);
        if (grammar != null) {
            grammar.rSetParentRNode(this);
        }
    }

    /**
     * Adds the VxmlGrammar property <b>grammar</b>.
     *
     * @param grammar
     */
    public void addGrammar(VxmlGrammar[] grammar) {
        for (int i = 0;i < grammar.length;i++) {
            addGrammar(grammar[i]);
        }
        for (int i = 0;i < grammar.length;i++) {
            grammar[i].rSetParentRNode(this);
        }
    }

    /**
     * Gets number of the VxmlGrammar property <b>grammar</b>.
     *
     * @return int
     */
    public int sizeGrammar() {
        return (grammar_.size());
    }

    /**
     * Gets the VxmlGrammar property <b>grammar</b> by index.
     *
     * @param index
     * @return VxmlGrammar
     */
    public VxmlGrammar getGrammar(int index) {
        return ((VxmlGrammar)grammar_.get(index));
    }

    /**
     * Sets the VxmlGrammar property <b>grammar</b> by index.
     *
     * @param index
     * @param grammar
     */
    public void setGrammar(int index, VxmlGrammar grammar) {
        this.grammar_.set(index, grammar);
        if (grammar != null) {
            grammar.rSetParentRNode(this);
        }
    }

    /**
     * Adds the VxmlGrammar property <b>grammar</b> by index.
     *
     * @param index
     * @param grammar
     */
    public void addGrammar(int index, VxmlGrammar grammar) {
        this.grammar_.add(index, grammar);
        if (grammar != null) {
            grammar.rSetParentRNode(this);
        }
    }

    /**
     * Remove the VxmlGrammar property <b>grammar</b> by index.
     *
     * @param index
     */
    public void removeGrammar(int index) {
        this.grammar_.remove(index);
    }

    /**
     * Remove the VxmlGrammar property <b>grammar</b> by object.
     *
     * @param grammar
     */
    public void removeGrammar(VxmlGrammar grammar) {
        this.grammar_.remove(grammar);
    }

    /**
     * Clear the VxmlGrammar property <b>grammar</b>.
     *
     */
    public void clearGrammar() {
        this.grammar_.clear();
    }

    /**
     * Gets the element to be used in the object construction.
     *
     * @return Element
     */
    public Element rGetElement() {
        return (xmlElement);
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.append("<");
        URelaxer.makeQName(prefix, "link", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (fetchhint_ != null) {
            buffer.append(" ");
            buffer.append("fetchhint");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchhint())));
            buffer.append("\"");
        }
        if (fetchtimeout_ != null) {
            buffer.append(" ");
            buffer.append("fetchtimeout");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchtimeout())));
            buffer.append("\"");
        }
        if (maxage_ != null) {
            buffer.append(" ");
            buffer.append("maxage");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxage())));
            buffer.append("\"");
        }
        if (maxstale_ != null) {
            buffer.append(" ");
            buffer.append("maxstale");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxstale())));
            buffer.append("\"");
        }
        if (next_ != null) {
            buffer.append(" ");
            buffer.append("next");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getNext())));
            buffer.append("\"");
        }
        if (expr_ != null) {
            buffer.append(" ");
            buffer.append("expr");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getExpr())));
            buffer.append("\"");
        }
        if (fetchaudio_ != null) {
            buffer.append(" ");
            buffer.append("fetchaudio");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchaudio())));
            buffer.append("\"");
        }
        if (dtmf_ != null) {
            buffer.append(" ");
            buffer.append("dtmf");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getDtmf())));
            buffer.append("\"");
        }
        if (event_ != null) {
            buffer.append(" ");
            buffer.append("event");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getEvent())));
            buffer.append("\"");
        }
        buffer.append(">");
        size = this.grammar_.size();
        for (int i = 0;i < size;i++) {
            VxmlGrammar value = (VxmlGrammar)this.grammar_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "link", buffer);
        buffer.append(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.write("<");
        URelaxer.makeQName(prefix, "link", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (fetchhint_ != null) {
            buffer.write(" ");
            buffer.write("fetchhint");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchhint())));
            buffer.write("\"");
        }
        if (fetchtimeout_ != null) {
            buffer.write(" ");
            buffer.write("fetchtimeout");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchtimeout())));
            buffer.write("\"");
        }
        if (maxage_ != null) {
            buffer.write(" ");
            buffer.write("maxage");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxage())));
            buffer.write("\"");
        }
        if (maxstale_ != null) {
            buffer.write(" ");
            buffer.write("maxstale");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxstale())));
            buffer.write("\"");
        }
        if (next_ != null) {
            buffer.write(" ");
            buffer.write("next");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getNext())));
            buffer.write("\"");
        }
        if (expr_ != null) {
            buffer.write(" ");
            buffer.write("expr");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getExpr())));
            buffer.write("\"");
        }
        if (fetchaudio_ != null) {
            buffer.write(" ");
            buffer.write("fetchaudio");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchaudio())));
            buffer.write("\"");
        }
        if (dtmf_ != null) {
            buffer.write(" ");
            buffer.write("dtmf");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getDtmf())));
            buffer.write("\"");
        }
        if (event_ != null) {
            buffer.write(" ");
            buffer.write("event");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getEvent())));
            buffer.write("\"");
        }
        buffer.write(">");
        size = this.grammar_.size();
        for (int i = 0;i < size;i++) {
            VxmlGrammar value = (VxmlGrammar)this.grammar_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</");
        URelaxer.makeQName(prefix, "link", buffer);
        buffer.write(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.print("<");
        URelaxer.makeQName(prefix, "link", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (fetchhint_ != null) {
            buffer.print(" ");
            buffer.print("fetchhint");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchhint())));
            buffer.print("\"");
        }
        if (fetchtimeout_ != null) {
            buffer.print(" ");
            buffer.print("fetchtimeout");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchtimeout())));
            buffer.print("\"");
        }
        if (maxage_ != null) {
            buffer.print(" ");
            buffer.print("maxage");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxage())));
            buffer.print("\"");
        }
        if (maxstale_ != null) {
            buffer.print(" ");
            buffer.print("maxstale");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxstale())));
            buffer.print("\"");
        }
        if (next_ != null) {
            buffer.print(" ");
            buffer.print("next");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getNext())));
            buffer.print("\"");
        }
        if (expr_ != null) {
            buffer.print(" ");
            buffer.print("expr");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getExpr())));
            buffer.print("\"");
        }
        if (fetchaudio_ != null) {
            buffer.print(" ");
            buffer.print("fetchaudio");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchaudio())));
            buffer.print("\"");
        }
        if (dtmf_ != null) {
            buffer.print(" ");
            buffer.print("dtmf");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getDtmf())));
            buffer.print("\"");
        }
        if (event_ != null) {
            buffer.print(" ");
            buffer.print("event");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getEvent())));
            buffer.print("\"");
        }
        buffer.print(">");
        size = this.grammar_.size();
        for (int i = 0;i < size;i++) {
            VxmlGrammar value = (VxmlGrammar)this.grammar_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "link", buffer);
        buffer.print(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getFetchhintAsString() {
        return (URelaxer.getString(getFetchhint()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getFetchtimeoutAsString() {
        return (URelaxer.getString(getFetchtimeout()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getMaxageAsString() {
        return (URelaxer.getString(getMaxage()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getMaxstaleAsString() {
        return (URelaxer.getString(getMaxstale()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getNextAsString() {
        return (URelaxer.getString(getNext()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getExprAsString() {
        return (URelaxer.getString(getExpr()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getFetchaudioAsString() {
        return (URelaxer.getString(getFetchaudio()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getDtmfAsString() {
        return (URelaxer.getString(getDtmf()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getEventAsString() {
        return (URelaxer.getString(getEvent()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setFetchhintByString(String string) {
        setFetchhint(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setFetchtimeoutByString(String string) {
        setFetchtimeout(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setMaxageByString(String string) {
        setMaxage(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setMaxstaleByString(String string) {
        setMaxstale(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setNextByString(String string) {
        setNext(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setExprByString(String string) {
        setExpr(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setFetchaudioByString(String string) {
        setFetchaudio(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setDtmfByString(String string) {
        setDtmf(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setEventByString(String string) {
        setEvent(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(grammar_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>VxmlLink</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "link")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        while (true) {
            if (!VxmlGrammar.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlLink</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlLink</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
