/*
 * Galatea Dialog Studio:
 * (c)2008 Takuya NISHIMOTO (nishimoto [atmark] m.ieice.org)
 * (c)2003 Takuya NISHIMOTO (nishimoto [atmark] m.ieice.org)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: Logger.java,v 1.9 2009/02/16 05:35:59 nishimoto Exp $
 */

package galatea.logger;

import galatea.util.Property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.Vector;

public class Logger
{
	static private int count_ = 0;
	private String name_ = "DM";
	
	private static ArrayList<ILoggerListener> 
		listeners = new ArrayList<ILoggerListener>();

	public static void addListener(ILoggerListener ls) {
		listeners.add(ls);
	}

	/**
	 * usage: 
	 * private Logger logger = new Logger(this.getClass());
	 * logger.print("hello");
	 */
	@SuppressWarnings("unchecked")
	public Logger(Class class1) {
		name_ = class1.getSimpleName();
	    String pkg = class1.getPackage().getName();
		int debuglevel = Property.getAsInt("Logger." + name_, 0);
		_addClass(pkg, name_, (debuglevel != 0));
	}

	public static void doPrint(String msg, String name) {
		String str = "[" + (++count_) + " " + name + " " 
				+ Thread.currentThread().getName() 
				+ "] " + msg;
		//System.err.println(str);
    	for (ILoggerListener l : listeners) {
    		l.addLoggerEvent(str);
    	}
	}
		
	public void print(String msg) {
		int debuglevel = Property.getAsInt("Logger." + name_, 0);
		if (debuglevel != 0)
			Logger.doPrint(msg, name_);
	}
	
	// level 0: most important
	public void print(String msg, int level) {
		int debuglevel = Property.getAsInt("Logger." + name_, 0);
		if (debuglevel >= level)
			Logger.doPrint(msg, name_);
	}
	
	public void err(String msg) {
		Logger.doPrint(msg, name_);
	}
	
	public void ASSERT(boolean bool, String msg) {
		int debuglevel = Property.getAsInt("Logger." + name_, 0);
		if (debuglevel != 0) {
			if (bool == false) {
				System.err.println("ASSERTION FAILED: "+msg);
				System.exit(1);
			}
		}
	}
	
	public void ASSERT(boolean bool, String msg, int level) {
		int debuglevel = Property.getAsInt("Logger." + name_, 0);
		if (debuglevel >= level) {
			if (bool == false) {
				System.err.println("ASSERTION FAILED: "+msg);
				System.exit(1);
			}
		}
	}
	
	
    @SuppressWarnings("unchecked")
	public static void updateEnableFlags() {
		Properties props = new Properties(System.getProperties());
    	for (int i = 0, n = enableFlagsDataVector_.size(); i < n; i++) {
    		Vector<Object> v = (Vector<Object>) enableFlagsDataVector_.get(i);
    		String s = (String) v.get(1);
    		boolean b = ((Boolean)v.get(2)).booleanValue();
    		String value = "0";
    		if (b) { 
    			value = "1";
    		}
			props.setProperty("Logger." + s, value);
    	}
		System.setProperties(props);
	}
	
    private static Vector<Object> enableFlagsDataVector_ = new Vector<Object>();
    
    @SuppressWarnings("unchecked")
	private static void _addClass(String pkg, String name, boolean flag) {
    	for (int i = 0, n = enableFlagsDataVector_.size(); i < n; i++) {
    		Vector<Object> v = (Vector<Object>) enableFlagsDataVector_.get(i);
    		String s = (String) v.get(1);
    		if (s.equals(name)) {
    			return; // avoid duplicate
    		}
    	}
	    Object[] data = {pkg, name, flag};
    	Vector<Object> v = new Vector<Object>(Arrays.asList(data));
    	enableFlagsDataVector_.add(v);
    	needUpdate_ = true;
    }
    
	public static Vector<Object> getEnableFlagsDataVector() {
	    return enableFlagsDataVector_;
	}

	public static Vector<String> getColumnNamesVector() {
	    String[] columnNames = { "Package", "Name", "Enabled" };
	    Vector<String> columnNamesVector = new Vector<String>(Arrays.asList(columnNames));
	    return columnNamesVector;
	}

	private static boolean needUpdate_ = false;
	
	public static boolean needUpdate() {
		return needUpdate_;
	}

	public static void updateDone() {
		needUpdate_ = false;
	}

}
