/**
 * $Id: AudioRecorderSubModule.java,v 1.2 2008/11/03 00:13:04 nishimoto Exp $
 * http://www.hellohiro.com/sound.htm
 */
package galatea.io.plugins;

import galatea.logger.Logger;
import galatea.outitem.AudioOutItem;
import galatea.outitem.OutItem;
import galatea.outitem.RecordOutItem;
import galatea.submodule.AbstractSubModule;
import galatea.util.Util;

import java.io.File;
import java.io.IOException;

import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioRecorderSubModule extends AbstractSubModule
{
	private Logger dbg = new Logger(this.getClass());
    private boolean active = false;
    private String filename;
	private String id;
	private long maxDurationInMilliSec = 1000;
	//
	private TargetDataLine m_line;
	private AudioFileFormat.Type m_targetType;
	private AudioInputStream m_audioInputStream;
	private File m_outputFile;
	private boolean m_bRecording;
    
	public boolean startOutput(OutItem item) {
		if (!(item instanceof RecordOutItem)) return false;
		RecordOutItem reco = (RecordOutItem)item;
		filename = reco.getTempFileName();
		maxDurationInMilliSec = reco.getMaxDurationInMilliSec();
		id = filename;
		Runnable r = new Runnable() {
			public void run() {
				_record();
				if (receiver_ != null) {
					receiver_.receiveOutputReady("record", id);
				}
			}
		};
		Thread th = new Thread(r);
		th.start();
		if (receiver_ != null) {
			receiver_.receiveOutputBusy("record", id);
		}
		return true;
	}

	public boolean stopOutput(OutItem item) {
		if (item instanceof RecordOutItem) {
	        active = false;
			return true;
		}
		return false;
	}
	
	private boolean _record() {
	    try {
	    	File outputFile = new File(filename);
	    	AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 
	                                                16000.0F, // 44100.0F:44.1K (sample-rate)
	                                                16, // bit/sample
	                                                1, // 1:mono 2:stereo
	                                                2, // bytes/frame
	                                                16000.0F, // frame-rate
	                                                false // false:little-endian
	                                                );
	    	DataLine.Info info = new DataLine.Info(TargetDataLine.class, audioFormat);
	    	TargetDataLine targetDataLine = (TargetDataLine)AudioSystem.getLine(info);
	    	targetDataLine.open(audioFormat);
	    	AudioFileFormat.Type targetType = AudioFileFormat.Type.WAVE;
	    	m_line = targetDataLine;
	    	m_audioInputStream = new AudioInputStream(targetDataLine);
	    	m_targetType = targetType;
	    	m_outputFile = outputFile;
	    	startRecording();
	    	Thread.sleep(maxDurationInMilliSec);
	    	targetDataLine.flush();
	    	targetDataLine.close();
	    	stopRecording();
	    } catch (Exception e) {
	    	e.printStackTrace();
		    return false;
	    }
	    return true;
	}

	public void startRecording() {
		m_line.start();
		m_bRecording = true;
		Runnable r = new Runnable() {
			@Override
			public void run() {
			    try {
					AudioSystem.write(m_audioInputStream, m_targetType, m_outputFile);
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		};
		Thread th = new Thread(r);
		th.start();
	}

	public void stopRecording() {
		m_line.stop();
		m_line.close();
		m_bRecording = false;
	}
	
	/**
	 * $ aplay /tmp/hoge.wav
	 * 再生中 WAVE '/tmp/hoge.wav' : Signed 16 bit Little Endian, レート 16000 Hz, モノラル
	 */
	public static void main(String argv[]) 
	{
		RecordOutItem reco = new RecordOutItem();
		reco.setTempFileName("/tmp/hoge.wav");
		reco.setMaxDurationInSec(3.0);
		// 3(sec) * 16000(Hz) * 2(bytes/sample) = 96000(bytes)
		System.out.printf("file:%s\n", reco.getTempFileName());
		AudioRecorderSubModule module = new AudioRecorderSubModule();
		module.startOutput(reco);
		try {
			Thread.sleep(reco.getMaxDurationInMilliSec() + 1000);
		} catch (InterruptedException e) {	}
		//module.stopOutput(reco);
		System.out.println("done");
		// 
	}
	
}
