/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishimoto [atmark] m.ieice.org)
 *
 * $Id: CompositeCommand.java,v 1.3 2009/01/28 13:51:17 nishimoto Exp $
 */

package galatea.command;

import galatea.dialog.RuntimeError;
import galatea.logger.Logger;

import java.util.ArrayList;

public class CompositeCommand extends Command
{
	private Logger dbg = new Logger(this.getClass());
	private ArrayList<Command> commands_ = null;
	
	public CompositeCommand(ArrayList<Command> v)
	{
		commands_ = v;
	}
	
	public CompositeCommand(ArrayList<Command> v, String cond)
	{
		commands_ = v;
		setCondition(cond);
	}
	
	public void setCommands(ArrayList<Command> v)
	{
		commands_ = v;
	}
	
	public ArrayList<Command> getCommands()
	{
		return commands_;
	}
	
	public void addCommand(Command c)
	{
		commands_.add(c);
	}
	
	public void addScriptCommand(String script)
	{
		commands_.add(new EvaluateCommand(script));
	}
	
	public void addScriptCommand(String script, String with)
	{
		commands_.add(new EvaluateCommand(script, with));
	}
	
	
	public String toString()
	{
		String s = "  <cmd";
		if (hasCondition()) {
			s += " cond=\"" + getConditionAsEncodedString() + "\"";
		}
		s += ">\n";
		int n = commands_.size();
		for(int i=0; i<n; i++) {
			Command cmd = (Command)commands_.get(i);
			s += " " + cmd.toString();
			s += "\n";
		}
		s += "  </cmd>";
		return s;
	}
	
	public void execute() throws RuntimeError
	{
		if ( evaluateCondition() == true ) {
			dbg.print("CC:adding "+commands_.size()+" command(s).");
			interpreterContext_.insertCommandsTop(commands_);
		}
	}
}
