/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishimoto [atmark] m.ieice.org)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: DeviceEvent.java,v 1.2 2009/01/28 13:51:17 nishimoto Exp $
 */
package galatea.io;

import galatea.relaxer.event.EventEv;

import java.io.StringReader;

public class DeviceEvent {
	public static class Type {
		private String type_;
		public static final DeviceEvent.Type INPUT
			= new DeviceEvent.Type("INPUT");
		public static final DeviceEvent.Type OUTPUT
			= new DeviceEvent.Type("OUTPUT");
		private Type(String type) {
			type_ = type;
		}
		public String toString() {
			return type_;
		}
	}
	
	public static class State {
		private String type_;
		public static final DeviceEvent.State READY
			= new DeviceEvent.State("READY");
		public static final DeviceEvent.State BUSY
			= new DeviceEvent.State("BUSY");
		public static final DeviceEvent.State EVENT
			= new DeviceEvent.State("EVENT");
		protected State(String type) {
			type_ = type;
		}
		public String toString() {
			return type_;
		}
	}
	
	private DeviceEvent.Type type_;
	private DeviceEvent.State state_;
	private String str_;
	private String str2_;
	
	private DeviceEvent.Type getDeviceType() {
		return type_;
	}
	
	private DeviceEvent.State getState() {
		return state_;
	}
	
	public String getString1() {
		return str_;
	}
	
	public String getString2() {
		return str2_;
	}
	
//	public Object getSource()
//	{
//		return src_;
//	}
	
	protected DeviceEvent( DeviceEvent.Type t, DeviceEvent.State s, 
			String str, String str2) {
		type_ = t;
		state_ = s;
		str_ = str;
		str2_ = str2;
	}
	
	public static DeviceEvent newOutputBusyInstance(String s1, String s2) {
		return new DeviceEvent(Type.OUTPUT, State.BUSY, s1, s2);
	}
	
	public static DeviceEvent newOutputBusyInstance(String s1) {
		return new DeviceEvent(Type.OUTPUT, State.BUSY, s1, null);
	}
	
	public static DeviceEvent newOutputReadyInstance(String s1, String s2) {
		return new DeviceEvent(Type.OUTPUT, State.READY, s1, s2);
	}

	public static DeviceEvent newOutputReadyInstance(String s1) {
		return new DeviceEvent(Type.OUTPUT, State.READY, s1, null);
	}
	
	public EventEv getEv() throws Exception {
		if (str2_ == null) 
			return null;
		EventEv ev = null;
		String s = str2_;
		StringReader reader = new StringReader(s);
		try {
			ev = new EventEv(reader);
		} catch (Exception e) {
			System.err.println("[DM] DeviceEvent error: " + e.getMessage());
			System.err.println("[DM] " + s);
			ev = null;
		}
		/*
		 ev = new EventEv(reader);
		 */
		return ev;
	}
	
	
	public String toString() {
		DeviceEvent.Type devtype = getDeviceType();
		DeviceEvent.State state = getState();
		StringBuffer sb = new StringBuffer();
//		sb.append(devtype.toString());
//		sb.append(" ");
		sb.append(state.toString());
		sb.append(" ");
		sb.append(getString1());
		sb.append(" ");
		sb.append(getString2());
		return sb.toString();
	}

	public boolean isOutputBusyEvent() {
		if (type_ == Type.OUTPUT && state_ == State.BUSY) return true;
		return false;
	}

	public boolean isOutputReadyEvent() {
		if (type_ == Type.OUTPUT && state_ == State.READY) return true;
		return false;
	}
	
}
