#!/usr/bin/ruby -Ke
# $Id: DIM.rb,v 1.2 2008/10/11 11:40:52 nishimoto Exp $
# 
# DIM = Dynamic Interaction Manager
# used for AutoGaze 
#
# by Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
#

require 'GalateaBase.rb'

class DIM < GalateaBase
  def initialize
    super
    @modulename = "DIM"
    @debug = false

    @useEventViewer = 0

    @mutex = Mutex.new
    @clockPrev = 0.0
    @clockCurr = 0.0

    @autoGaze = 0
    
    @agentSpeakState = 0 
    # managed by AM-MCL
    #  0: not-speaking
    #  1: preparing
    #  2: speaking

    @userSpeakState = 0
    #  0: not-speaking
    #  1: startrec .. endrec
    
    @agentAttentionState = 0 
    # -1: busy
    #  0: not-gazing & not-speaking
    #  1:     gazing & not-speaking
    #  2:     gazing &     speaking

    @isAgentTurn = 0

    @userAnxiety    = 0.0
    @userAnxietyMax = 1.0
    
    @visualAmount   = 0.0
    @visualMin      = 1.0
    @visualCapacity = 5.0

    Thread.start do
      while true
		@mutex.synchronize do
		  doStepCalc
		  if @userSpeakState == 0
		    doInputVisualResponse
		  end
		end
		sleep 0.1
		@clockPrev = @clockCurr
		@clockCurr += 0.1
		sendToEventViewer( "Blink", 0 )
      end
    end

  end

  def sendToEventViewer(slot, val)
    if @useEventViewer == 1
      sendToEventViewer( slot, val ) 
    end
  end

  def doStepCalc
    # agentAttentionState
    if @agentAttentionState == 0 && @userSpeakState != 0 
      @agentAttentionState = 1
    end

    # visualAmount

    if @agentAttentionState == 0 
      # 0: not-gazing & not-speaking
      @visualAmount -= 5.0 * (@clockCurr - @clockPrev) 
    elsif @agentAttentionState == 1
      # 1:     gazing & not-speaking
      @visualAmount += 1.5 * (@clockCurr - @clockPrev)
    elsif @agentAttentionState == 2
      # 2:     gazing & speaking
      @visualAmount += 1.0 * (@clockCurr - @clockPrev)
    end
 
    if @visualAmount <  0 then @visualAmount =  0 end
    if @visualAmount > 10 then @visualAmount = 10 end

    # user anxiety

    if @isAgentTurn == 1
      @userAnxiety += 3.0 * (@clockCurr - @clockPrev)
    else
      @userAnxiety -= 2.0 * (@clockCurr - @clockPrev)
    end

    if @userAnxiety <  0 then @userAnxiety =  0 end
    if @userAnxiety > 10 then @userAnxiety = 10 end

    # output
    sendToEventViewer( "AgentAttentionState", @agentAttentionState.to_s )
    sendToEventViewer( "VisualAmount", @visualAmount.to_s )
    sendToEventViewer( "UserAnxiety", @userAnxiety.to_s )
    sendToEventViewer( "AgentTurn", @isAgentTurn.to_s )
  end

  def doInputVisualResponse
    if @visualAmount < @visualMin 
      doMoreVisual
    elsif @visualCapacity < @visualAmount
      doLessVisual
    end
  end

  def doBlink
    sendToEventViewer( "Blink", 1 )
    send_set( "FS-MCL", "Action", "Blink" )
    @visualAmount -= 4.0
  end

  def doWithdrawGaze
    if @agentAttentionState != 0
      send_set( "FS-MCL", "Action", "Thinking" )
      @agentAttentionState = 0
    end
  end

  def doGaze
    if @agentAttentionState != 1
      send_set( "FS-MCL", "Action", "InfoRequest" )
      @agentAttentionState = 1
    end
  end

  def setBusy
    send_set( "FS-MCL", "Action", "Busy" )
  end

  def doMoreVisual
    doGaze
  end

  def doLessVisual
    if @agentAttentionState == 0
      if rand(50) == 0 then doBlink end
    elsif @agentAttentionState == 1
      if @userAnxiety < @userAnxietyMax
	if rand(3) == 0
	  doWithdrawGaze
	else
	  doBlink
	end
      else
	doBlink
      end
    elsif @agentAttentionState == 2
      if rand(30) == 0 then doBlink end
    end
  end

  def do_set(slot, arg)
    super
    if slot == "AgentSpeakState"
      @agentSpeakState = arg.to_i
      if @agentSpeakState == 2 then 
        @isAgentTurn = 0 
        send_set( "FS-MCL", "Action", "Speaking" )
      end

      if @agentAttentionState == 1 then
		if @autoGaze == 1 
	          send_set( "FS-MCL", "Action", "InfoRequest" )
		end
		@agentAttentionState = 2
	      elsif @agentAttentionState == 2
		if @agentSpeakState == 0 && @autoGaze == 1 then
		  doGaze
		end
      end
      
    elsif slot == "UserSpeakState"
      @userSpeakState = arg.to_i
      if @userSpeakState == 1 then @isAgentTurn = 1 end
      # if user begin speaking then agent start gazing
      if @agentAttentionState == 0 && @userSpeakState == 1 && @autoGaze == 1 
		doGaze
      end
      
    elsif slot == "Busy"
      busy = arg.to_i
      if busy == 1 
		@agentAttentionState = -1
		setBusy
      elsif busy == 0 && @agentAttentionState == -1
		@agentAttentionState = 0
      end
      
    elsif slot == "AutoGaze"
      @autoGaze = arg.to_i
      
    end

  end

end

DIM.new.run

# end of file
