package com.shin1ogawa.page;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.t2framework.t2.annotation.core.Ajax;
import org.t2framework.t2.annotation.core.Default;
import org.t2framework.t2.annotation.core.Page;
import org.t2framework.t2.contexts.WebContext;
import org.t2framework.t2.navigation.Json;
import org.t2framework.t2.spi.Navigation;

import com.google.inject.Inject;
import com.google.inject.servlet.RequestScoped;
import com.shin1ogawa.entity.Messages;
import com.shin1ogawa.service.IMessagesService;
import com.shin1ogawa.service.MessagesService;
import com.shin1ogawa.util.CacheUtil;

/**
 * @author shin1ogawa
 */
@RequestScoped
@Page("listMessage")
public class ListMessage {

	private static final Logger LOGGER = LoggerFactory.getLogger(ListMessage.class);

	@Inject
	IMessagesService service;


	/**
	 * TODO for shin1ogawa
	 * @param context
	 * @return {@link Navigation}
	 */
	@Ajax
	@Default
	public Navigation list(WebContext context) {
		List<Messages> result = null;
		if (CacheUtil.isCached(MessagesService.class.getName())) {
			result = CacheUtil.getCache(MessagesService.class.getName());
			LOGGER.info("hit the cache from " + ListMessage.class.getName() + ":" + "list");
		} else {
			result = new ArrayList<Messages>();
			List<Messages> messageList = service.listAll();
			if (messageList != null) {
				result.addAll(messageList);
			}
			CacheUtil.putCache(MessagesService.class.getName(), result);
			LOGGER.info("cached to " + ListMessage.class.getName() + ":" + "list");
		}
		return new Json(ResultObject.createResultObject(result));
	}
}
