package ${package}.page;

import java.util.HashMap;

import com.google.appengine.api.users.User;
import com.google.appengine.api.users.UserServiceFactory;

public class ResultObject<T> extends HashMap<String, Object> {

	/**
	 * static factory method
	 * @param <T>
	 * @param data
	 * @return {@link ResultObject}
	 */
	public static <T>ResultObject<T> createResultObject(T data) {
		User user = UserServiceFactory.getUserService().getCurrentUser();
		ResultObject<T> object = new ResultObject<T>();
		if (user != null) {
			object.put("user", user);
			object.put("userServiceUrl", UserServiceFactory.getUserService().createLogoutURL("/"));
		} else {
			object.put("userServiceUrl", UserServiceFactory.getUserService().createLoginURL("/"));
		}
		object.put("data", data);
		return object;
	}
}
