package com.shin1ogawa;

import java.io.File;

import org.junit.After;
import org.junit.Before;

import com.google.appengine.api.datastore.dev.LocalDatastoreService;
import com.google.appengine.api.mail.dev.LocalMailService;

/**
 * TestCaseのサンプル。
 * 
 * @author shin1ogawa
 */
public class AbstractGaeServiceTest {
	GaeServiceTestHelper testHelper;

	@Before
	public void setUp() {
		testHelper = new GaeServiceTestHelper(new File("target/testAppDir"));
		testHelper.setProperty(LocalDatastoreService.NO_STORAGE_PROPERTY,
				Boolean.TRUE.toString());
	}

	@After
	public void teawDown() {
		if (testHelper != null) {
			((LocalMailService) testHelper.getMailService())
					.clearSentMessages();
			((LocalDatastoreService) testHelper.getDatastoreService())
					.clearProfiles();
			testHelper.tearDown();
		}
	}
}
