<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="http://java.sun.com/jstl/core" prefix="c" %>

<html>
<head>
	<title>板一覧</title>
</head>
<body>
<c:choose>
	<c:when test="${user != null}">
	<p>Hello, <c:out value="${user.nickname}" />! (You can <a href="<c:out value="${logoutUrl}" />">sign out</a>.)</p>
	</c:when>
	<c:otherwise>
	<p>Hello, <a href="<c:out value="${loginUrl}" />">Sign in</a> to include your name with your post.</p>
	</c:otherwise>
</c:choose>

<h1>板一覧</h1>
<c:choose>
<c:when test="${noBoards == true}">まだ板がありません。</c:when>
<c:otherwise>
<ul>
<c:forEach var="board" items="${boards}" varStatus="s">
	<c:choose>
	<c:when test="${board.user == null}">
		<li><a href="/board?id=<c:out value="${board.id}" />"><c:out value="${board.title}" /></a>(anonymous, <c:out value="${board.created}" />>)</li>
	</c:when>
	<c:otherwise>
		<li><a href="/board?id=<c:out value="${board.id}" />"><c:out value="${board.title}" /></a>(<c:out value="${board.user.nickname}" />, <c:out value="${board.created}" />>)</li>
	</c:otherwise>
	</c:choose>
</c:forEach>
</ul>
</c:otherwise>
</c:choose>

<form action="/board/post" method="post">
  <div><input type="text" name="title" size="100"/></div>
  <div><input type="submit" value="New Board" /></div>
</form>

</body>
</html>
