package com.shin1ogawa.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.jdo.annotations.IdGeneratorStrategy;
import javax.jdo.annotations.IdentityType;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;

import com.google.appengine.api.datastore.Key;

@PersistenceCapable(identityType = IdentityType.APPLICATION, detachable = "true")
public class ListPropertyEntity {
	@PrimaryKey
	@Persistent(valueStrategy = IdGeneratorStrategy.IDENTITY)
	private Key key;

	@Persistent
	private String name;

	@Persistent
	private List<String> stringProperty = new ArrayList<String>(0);

	@Persistent
	private List<Date> startAndEndDate = new ArrayList<Date>(2);

	/**
	 * @return the key
	 */
	public Key getKey() {
		return key;
	}

	/**
	 * @param key
	 *            the key to set
	 */
	public void setKey(Key key) {
		this.key = key;
	}

	/**
	 * @return the stringProperty
	 */
	public List<String> getStringProperty() {
		return stringProperty;
	}

	/**
	 * @param stringProperty
	 *            the stringProperty to set
	 */
	public void setStringProperty(List<String> stringProperty) {
		this.stringProperty = stringProperty;
	}

	/**
	 * @return the startAndEndDate
	 */
	public List<Date> getStartAndEndDate() {
		return startAndEndDate;
	}

	/**
	 * @param startAndEndDate
	 *            the startAndEndDate to set
	 */
	public void setStartAndEndDate(List<Date> startAndEndDate) {
		this.startAndEndDate = startAndEndDate;
	}

	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}
}
