package com.shin1ogawa.entity;

import java.io.Serializable;
import java.util.List;
import java.util.Set;

import javax.jdo.annotations.IdGeneratorStrategy;
import javax.jdo.annotations.IdentityType;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;
import javax.jdo.annotations.Version;
import javax.jdo.annotations.VersionStrategy;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.Text;

@SuppressWarnings("serial")
@PersistenceCapable(identityType = IdentityType.APPLICATION)
@Version(strategy = VersionStrategy.VERSION_NUMBER)
public class ParentA implements Serializable {
	@PrimaryKey
	@Persistent(valueStrategy = IdGeneratorStrategy.IDENTITY)
	private Key key;

	@Persistent(defaultFetchGroup = "true")
	private Text text;

	@Persistent(defaultFetchGroup = "true")
	private ChildA1 childA1;

	@Persistent(defaultFetchGroup = "true")
	private List<ChildA2> childA2list;

	@Persistent(defaultFetchGroup = "true")
	private Key otherAKey;

	@Persistent(defaultFetchGroup = "true")
	private Set<Key> otherBKeys;

	public Key getKey() {
		return key;
	}

	public void setKey(Key key) {
		this.key = key;
	}

	public ChildA1 getChildA1() {
		return childA1;
	}

	public void setChildA1(ChildA1 childA1) {
		this.childA1 = childA1;
	}

	public List<ChildA2> getChildA2list() {
		return childA2list;
	}

	public void setChildA2list(List<ChildA2> childA2list) {
		this.childA2list = childA2list;
	}

	public Key getOtherAKey() {
		return otherAKey;
	}

	public void setOtherAKey(Key otherAKey) {
		this.otherAKey = otherAKey;
	}

	public Set<Key> getOtherBKeys() {
		return otherBKeys;
	}

	public void setOtherBKeys(Set<Key> otherBKeys) {
		this.otherBKeys = otherBKeys;
	}

	public void setText(Text text) {
		this.text = text;
	}

	public Text getText() {
		return text;
	}
}
