/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.urlfetch.dev;

import com.google.appengine.api.urlfetch.URLFetchServicePb;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.StringRequestEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ServiceProvider(value=LocalRpcService.class)
public class LocalURLFetchService
implements LocalRpcService {
    private static final int TIMEOUT_IN_MS = 5000;
    static final int TRUNCATABLE_MAX_RESPONSE_LENGTH = 0x100000;
    static final int MAX_RESPONSE_LENGTH = 0x1000000;
    static final int MAX_REDIRECTS = 5;
    private static final Map<URLFetchServicePb.URLFetchRequest.RequestMethod, MethodFactory> METHOD_FACTORY_MAP = LocalURLFetchService.buildMethodFactoryMap();
    private final HttpClient httpClient = this.initializeHttpClient();

    private static Map<URLFetchServicePb.URLFetchRequest.RequestMethod, MethodFactory> buildMethodFactoryMap() {
        HashMap<URLFetchServicePb.URLFetchRequest.RequestMethod, MethodFactory> map = new HashMap<URLFetchServicePb.URLFetchRequest.RequestMethod, MethodFactory>();
        map.put(URLFetchServicePb.URLFetchRequest.RequestMethod.GET, new MethodFactory(){

            public HttpMethodBase buildMethod(URLFetchServicePb.URLFetchRequest request) {
                return new GetMethod(request.getUrl());
            }
        });
        map.put(URLFetchServicePb.URLFetchRequest.RequestMethod.DELETE, new MethodFactory(){

            public HttpMethodBase buildMethod(URLFetchServicePb.URLFetchRequest request) {
                return new DeleteMethod(request.getUrl());
            }
        });
        map.put(URLFetchServicePb.URLFetchRequest.RequestMethod.HEAD, new MethodFactory(){

            public HttpMethodBase buildMethod(URLFetchServicePb.URLFetchRequest request) {
                return new HeadMethod(request.getUrl());
            }
        });
        map.put(URLFetchServicePb.URLFetchRequest.RequestMethod.POST, new MethodFactory(){

            public HttpMethodBase buildMethod(URLFetchServicePb.URLFetchRequest request) {
                RedirectablePostMethod post = new RedirectablePostMethod(request.getUrl());
                if (request.hasPayload()) {
                    StringRequestEntity requestEntity = new StringRequestEntity(request.getPayload());
                    post.setRequestEntity(requestEntity);
                }
                return post;
            }
        });
        map.put(URLFetchServicePb.URLFetchRequest.RequestMethod.PUT, new MethodFactory(){

            public HttpMethodBase buildMethod(URLFetchServicePb.URLFetchRequest request) {
                PutMethod put = new PutMethod(request.getUrl());
                if (request.hasPayload()) {
                    StringRequestEntity requestEntity = new StringRequestEntity(request.getPayload());
                    put.setRequestEntity(requestEntity);
                }
                return put;
            }
        });
        return map;
    }

    protected HttpClient initializeHttpClient() {
        HttpClient theClient = new HttpClient(new MultiThreadedHttpConnectionManager());
        theClient.getParams().setLongParameter("http.connection-manager.timeout", 5000L);
        theClient.getParams().setIntParameter("http.protocol.max-redirects", 6);
        return theClient;
    }

    public String getPackage() {
        return "urlfetch";
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
    }

    public void start() {
    }

    public void stop() {
    }

    public URLFetchServicePb.URLFetchResponse fetch(LocalRpcService.Status status, URLFetchServicePb.URLFetchRequest request) {
        if (status == null) {
            throw new NullPointerException("status cannot be null.");
        }
        if (request == null) {
            throw new NullPointerException("request cannot be null.");
        }
        URLFetchServicePb.URLFetchResponse response = new URLFetchServicePb.URLFetchResponse();
        if (!this.hasValidURL(request)) {
            throw new ApiProxy.ApplicationException(URLFetchServicePb.URLFetchServiceError.ErrorCode.INVALID_URL.getValue(), "Invalid URL: " + request.getUrl());
        }
        MethodFactory methodFactory = METHOD_FACTORY_MAP.get(request.getMethodEnum());
        if (methodFactory == null) {
            throw new IllegalArgumentException("Unsupported method: " + request.getMethodEnum());
        }
        HttpMethodBase method = methodFactory.buildMethod(request);
        method.setFollowRedirects(request.isFollowRedirects());
        method.getParams().setIntParameter("http.connection.timeout", 5000);
        method.getParams().setIntParameter("http.socket.timeout", 5000);
        for (URLFetchServicePb.URLFetchRequest.Header pbHeader : request.headers()) {
            method.addRequestHeader(this.pbHeaderToJakartaHeader(pbHeader));
        }
        try {
            byte[] responseBodyBytes = this.doPrivilegedExecute(method, response);
            if (responseBodyBytes != null) {
                if (responseBodyBytes.length > this.getMaxResponseLength()) {
                    throw new ApiProxy.ApplicationException(URLFetchServicePb.URLFetchServiceError.ErrorCode.RESPONSE_TOO_LARGE.getValue(), "Response for URL " + request.getUrl() + " is too large.");
                }
                response.setContentAsBytes(this.limitLength(responseBodyBytes, response));
            }
            for (URLFetchServicePb.URLFetchResponse.Header header : this.jakartaHeadersToPbHeaders(method.getResponseHeaders())) {
                response.addHeader(header);
            }
        }
        catch (SocketTimeoutException ste) {
            throw new ApiProxy.ApplicationException(URLFetchServicePb.URLFetchServiceError.ErrorCode.DEADLINE_EXCEEDED.getValue(), "http method " + method.getName() + " against URL " + request.getUrl() + " timed out.");
        }
        catch (IOException e) {
            throw new ApiProxy.ApplicationException(URLFetchServicePb.URLFetchServiceError.ErrorCode.FETCH_ERROR.getValue(), "Received exception executing http method " + method.getName() + " against URL " + request.getUrl() + ": " + e.getMessage());
        }
        finally {
            method.releaseConnection();
        }
        return response;
    }

    private byte[] doPrivilegedExecute(final HttpMethodBase method, final URLFetchServicePb.URLFetchResponse response) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws IOException {
                    int result = LocalURLFetchService.this.httpClient.executeMethod(method);
                    response.setStatusCode(result);
                    return method.getResponseBody();
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new RuntimeException(e);
        }
    }

    byte[] limitLength(byte[] responseBody, URLFetchServicePb.URLFetchResponse response) {
        if (responseBody != null && responseBody.length > 0x100000) {
            byte[] newResponseBody = new byte[0x100000];
            System.arraycopy(responseBody, 0, newResponseBody, 0, newResponseBody.length);
            responseBody = newResponseBody;
            response.setContentWasTruncated(true);
        }
        return responseBody;
    }

    boolean hasValidURL(URLFetchServicePb.URLFetchRequest request) {
        URL url;
        if (!request.hasUrl() || request.getUrl().length() == 0) {
            return false;
        }
        try {
            url = new URL(request.getUrl());
        }
        catch (MalformedURLException e) {
            return false;
        }
        return url.getProtocol().equals("http") || url.getProtocol().equals("https");
    }

    Header pbHeaderToJakartaHeader(URLFetchServicePb.URLFetchRequest.Header pbHeader) {
        Header jakartaHeader = new Header();
        jakartaHeader.setName(pbHeader.getKey());
        jakartaHeader.setValue(pbHeader.getValue());
        return jakartaHeader;
    }

    URLFetchServicePb.URLFetchResponse.Header jakartaHeaderToPbHeader(Header header) {
        URLFetchServicePb.URLFetchResponse.Header pbHeader = new URLFetchServicePb.URLFetchResponse.Header();
        pbHeader.setKey(header.getName());
        pbHeader.setValue(header.getValue());
        return pbHeader;
    }

    int getMaxResponseLength() {
        return 0x1000000;
    }

    Collection<URLFetchServicePb.URLFetchResponse.Header> jakartaHeadersToPbHeaders(Header[] headers) {
        LinkedHashMap<String, URLFetchServicePb.URLFetchResponse.Header> newHeaders = new LinkedHashMap<String, URLFetchServicePb.URLFetchResponse.Header>(headers.length);
        for (Header header : headers) {
            String name = header.getName();
            URLFetchServicePb.URLFetchResponse.Header urlFetchHeader = (URLFetchServicePb.URLFetchResponse.Header)newHeaders.get(name);
            if (urlFetchHeader == null) {
                urlFetchHeader = new URLFetchServicePb.URLFetchResponse.Header();
                urlFetchHeader.setKey(name);
                newHeaders.put(name, urlFetchHeader);
            }
            if (urlFetchHeader.hasValue()) {
                urlFetchHeader.setValue(urlFetchHeader.getValue() + ", " + header.getValue());
                continue;
            }
            urlFetchHeader.setValue(header.getValue());
        }
        return newHeaders.values();
    }

    private static class RedirectablePostMethod
    extends PostMethod {
        private boolean followRedirects;

        public RedirectablePostMethod() {
        }

        public RedirectablePostMethod(String uri) {
            super(uri);
        }

        public void setFollowRedirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
        }

        public boolean getFollowRedirects() {
            return this.followRedirects;
        }
    }

    private static interface MethodFactory {
        public HttpMethodBase buildMethod(URLFetchServicePb.URLFetchRequest var1);
    }
}

