/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.lucy.inject;

import org.t2framework.commons.exception.IllegalAccessRuntimeException;
import org.t2framework.commons.exception.InvocationTargetRuntimeException;
import org.t2framework.commons.meta.ExpressionAware;
import org.t2framework.commons.meta.MethodDesc;
import org.t2framework.commons.util.Logger;
import org.t2framework.commons.util.PrintableUtil;
import org.t2framework.lucy.Lucy;
import org.t2framework.lucy.exception.CyclicReferenceRuntimeException;
import org.t2framework.lucy.inject.AbstractInjector;

public class MethodInjector
extends AbstractInjector<MethodDesc> {
    protected static Logger logger = Logger.getLogger(MethodInjector.class);
    protected final String targetClassName;
    protected final String targetMethodName;

    public MethodInjector(MethodDesc methodDesc) {
        super(methodDesc);
        this.targetClassName = methodDesc.getDeclaringClass().getName();
        this.targetMethodName = methodDesc.getMethodName();
    }

    @Override
    public <T> T inject(T t, Lucy lucy) throws CyclicReferenceRuntimeException, InvocationTargetRuntimeException, IllegalAccessRuntimeException {
        MethodDesc methodDesc = (MethodDesc)this.getConfigContainer();
        AbstractInjector.InjectInfo info = this.getInjectInfo();
        Class<?>[] types = this.getParameterTypes(methodDesc, info);
        Object[] args = this.prepareArgs(types, methodDesc, lucy, info);
        this.injectMethodDesc(methodDesc, t, args, types);
        return t;
    }

    protected Object[] prepareArgs(Class<?>[] types, MethodDesc methodDesc, Lucy lucy, AbstractInjector.InjectInfo info) {
        Object[] args = null;
        args = methodDesc.hasExpression() ? this.evaluateExpression((ExpressionAware)methodDesc, lucy) : super.prepareArgsByTypes(types, lucy, info);
        return args;
    }

    protected <T> void injectMethodDesc(MethodDesc methodDesc, T t, Object[] args, Class<?>[] types) {
        if (args == null) {
            this.logForNullInject(types);
            return;
        }
        if (1 < args.length || args.length == 1 && args[0] != null) {
            methodDesc.invoke(t, args);
        } else {
            this.logForNullInject(types);
        }
    }

    protected void logForNullInject(Class<?>[] types) {
        logger.log("DLucyCore0001", new Object[]{this.targetClassName, this.targetMethodName, PrintableUtil.toPrintableString((Object[])types)});
    }

    protected Class<?>[] getParameterTypes(MethodDesc methodDesc, AbstractInjector.InjectInfo info) {
        return info.hasParameterTypes() ? info.getParameterTypes() : methodDesc.getParameterTypes();
    }
}

