/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.lucy.inject;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.t2framework.commons.Constants;
import org.t2framework.commons.exception.ConstructorNotFoundRuntimeException;
import org.t2framework.commons.meta.BeanDesc;
import org.t2framework.commons.meta.ConfigContainer;
import org.t2framework.commons.meta.ConstructorDesc;
import org.t2framework.commons.meta.ExpressionAware;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.commons.util.Reflections;
import org.t2framework.lucy.Lucy;
import org.t2framework.lucy.annotation.core.Inject;
import org.t2framework.lucy.config.meta.InjectConfig;
import org.t2framework.lucy.config.meta.impl.ConstructorInjectConfig;
import org.t2framework.lucy.exception.ConstrucorInjectionFailureException;
import org.t2framework.lucy.exception.CyclicReferenceRuntimeException;
import org.t2framework.lucy.inject.AbstractInjector;
import org.t2framework.lucy.inject.InjectorUtil;

public class ConstructorInjector
extends AbstractInjector<BeanDesc<?>> {
    protected List<Constructor<?>> injectableConstructors = CollectionsUtil.newArrayList();
    private static final Comparator<Constructor<?>> CONSTRUCTOR_COMPARATOR = new Comparator<Constructor<?>>(){
        public static final int SORT = 1;
        public static final int NOCHANGE = 0;
        public static final int NOCHANGE2 = 0;

        @Override
        public int compare(Constructor<?> o1, Constructor<?> o2) {
            int len2;
            if (o1 == null || o2 == null) {
                return 0;
            }
            int len1 = o1.getParameterTypes().length;
            if (len1 < (len2 = o2.getParameterTypes().length)) {
                return 1;
            }
            if (len1 == len2) {
                return 0;
            }
            return 0;
        }
    };

    public ConstructorInjector(BeanDesc<?> container) {
        super((ConfigContainer)Assertion.notNull(container));
        this.findInjectableConstructors(((BeanDesc)this.getConfigContainer()).getConstructorDesc());
    }

    @Override
    public <T> T inject(T t, Lucy lucy) throws CyclicReferenceRuntimeException, ConstrucorInjectionFailureException {
        this.assertInjectableConstructorsExists();
        Object[] args = Constants.EMPTY_ARRAY;
        AbstractInjector.InjectInfo injectInfo = this.getInjectInfo();
        for (Constructor<?> constructor : this.injectableConstructors) {
            if (Reflections.ConstructorUtil.isDefaultConstructor(constructor)) {
                args = Constants.EMPTY_ARRAY;
                break;
            }
            Class<?>[] paramTypes = this.getParameterTypes(constructor, injectInfo);
            args = this.prepareArgs(paramTypes, ((BeanDesc)this.getConfigContainer()).getConstructorDesc(), lucy, injectInfo);
            if (args != null && Assertion.hasNotNull((Object[])args)) break;
            args = null;
        }
        if (args == null) {
            throw new ConstrucorInjectionFailureException(this.getConfigContainerName());
        }
        return (T)((BeanDesc)this.getConfigContainer()).newInstance(args);
    }

    protected Object[] prepareArgs(Class<?>[] types, ConstructorDesc<?> constructorDesc, Lucy lucy, AbstractInjector.InjectInfo info) {
        Object[] args = null;
        args = constructorDesc.hasExpression() ? this.evaluateExpression((ExpressionAware)constructorDesc, lucy) : super.prepareArgsByTypes(types, lucy, info);
        return args;
    }

    protected Class<?>[] getParameterTypes(Constructor<?> constructor, AbstractInjector.InjectInfo info) {
        return info != null && info.hasParameterTypes() ? info.getParameterTypes() : constructor.getParameterTypes();
    }

    protected void assertInjectableConstructorsExists() {
        if (this.injectableConstructors.size() < 1) {
            throw new ConstructorNotFoundRuntimeException(this.getConfigContainerName());
        }
    }

    protected String getConfigContainerName() {
        return ((BeanDesc)this.getConfigContainer()).getConcreteClass().getName();
    }

    protected boolean findInjectableConstructors(ConstructorDesc<?> constructorDesc) {
        if (constructorDesc.hasOnlyDefaultConstructor()) {
            this.addDefaultConstructorAsLast(constructorDesc);
            return true;
        }
        if (!this.injectByAnnotation && !this.injectByConfiguration) {
            return false;
        }
        ConstructorInjectConfig config = this.getConstructorInjectConfig((ConfigContainer)constructorDesc);
        for (Constructor constructor : constructorDesc.getConstructors()) {
            if (constructor.isSynthetic() || constructor.isVarArgs()) continue;
            this.processConstructor(constructor, this.injectByAnnotation, this.injectByConfiguration, config);
        }
        if (!this.injectByConfiguration) {
            this.addDefaultConstructorAsLast(constructorDesc);
        }
        Collections.sort(this.injectableConstructors, CONSTRUCTOR_COMPARATOR);
        return true;
    }

    protected void processConstructor(Constructor<?> constructor, boolean injectByAnnotation, boolean injectByConfiguration, ConstructorInjectConfig config) {
        if (config != null && !config.isAutoinjected()) {
            Class<?>[] paramTypes = constructor.getParameterTypes();
            if (Reflections.ConstructorUtil.isDefaultConstructor(constructor)) {
                return;
            }
            if (!this.isInjectAnnotationPresent(constructor) && !this.isInjectConfigurationArgsEquals(config, paramTypes)) {
                return;
            }
        }
        this.injectableConstructors.add(constructor);
    }

    protected boolean isInjectAnnotationPresent(Constructor<?> constructor) {
        return this.injectByAnnotation && constructor.isAnnotationPresent(Inject.class);
    }

    protected boolean isInjectConfigurationArgsEquals(ConstructorInjectConfig config, Class<?>[] paramTypes) {
        return this.injectByConfiguration && config.getArgumentSize() == paramTypes.length;
    }

    protected void addDefaultConstructorAsLast(ConstructorDesc<?> container) {
        Constructor defaultConstructor = container.getConstructor(Constants.EMPTY_CLASS_ARRAY);
        if (defaultConstructor != null) {
            this.injectableConstructors.add(defaultConstructor);
        }
    }

    protected ConstructorInjectConfig getConstructorInjectConfig(ConfigContainer constructorDesc) {
        return (ConstructorInjectConfig)constructorDesc.findConfig(InjectConfig.class);
    }

    @Override
    protected void setup(BeanDesc<?> container) {
        ConstructorDesc constructorDesc = ((BeanDesc)this.getConfigContainer()).getConstructorDesc();
        this.injectByAnnotation = InjectorUtil.hasInjectAnnotation((ConfigContainer)constructorDesc);
        this.injectByConfiguration = InjectorUtil.hasInjectConfiguration((ConfigContainer)constructorDesc);
        if (this.injectByAnnotation || this.injectByConfiguration) {
            this.setInjectInfo(new AbstractInjector.InjectInfo((ConfigContainer)constructorDesc));
        }
    }
}

