/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.lucy;

import java.util.List;
import java.util.Map;
import org.t2framework.commons.meta.BeanDesc;
import org.t2framework.commons.meta.ClassDesc;
import org.t2framework.commons.meta.DescType;
import org.t2framework.commons.meta.MethodDesc;
import org.t2framework.commons.meta.PropertyDesc;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.lucy.spi.Behavior;

public class ConfigBindResult {
    protected BeanDesc<?> beanDesc;
    protected boolean initialized = false;
    protected Map<DescType, List<Behavior>> map = CollectionsUtil.newLinkedHashMap();
    protected List<Behavior> allBehaviors = CollectionsUtil.newLinkedList();

    public ConfigBindResult(BeanDesc<?> beanDesc) {
        this.beanDesc = beanDesc;
    }

    public BeanDesc<?> getKey() {
        return this.beanDesc;
    }

    public void addBehavior(DescType desc, Behavior b) {
        Assertion.notNull((Object)desc);
        Assertion.notNull((Object)b);
        List list = this.map.get(desc);
        if (list == null) {
            list = CollectionsUtil.newArrayList();
        }
        list.add(b);
        this.map.put(desc, list);
        this.allBehaviors.add(b);
    }

    public Behavior getBehavior(int index) {
        return this.allBehaviors.get(index);
    }

    public int getBehaviorsSize() {
        return this.allBehaviors.size();
    }

    public List<Behavior> getBehaviorList(DescType desc) {
        return this.map.get(desc);
    }

    public boolean hasClassDesc(ClassDesc<?> cd) {
        return cd != null && this.map.containsKey(cd);
    }

    public boolean hasMethodDesc(MethodDesc md) {
        return md != null && this.map.containsKey(md);
    }

    public boolean hasPropertyDesc(PropertyDesc<?> pd) {
        return pd != null && this.map.containsKey(pd);
    }

    public void initializeBehaviors() {
        for (Behavior b : this.allBehaviors) {
            b.init();
        }
        this.initialized = true;
    }

    public void destroyBehaviors() {
        for (Behavior b : this.allBehaviors) {
            b.destroy();
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }
}

