/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.urlfetch.dev;

import com.google.appengine.api.urlfetch.URLFetchServicePb;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ServiceProvider(value=LocalRpcService.class)
public class LocalURLFetchService
implements LocalRpcService {
    private static final int TIMEOUT_IN_MS = 5000;
    static final int TRUNCATABLE_MAX_RESPONSE_LENGTH = 0x100000;
    static final int MAX_RESPONSE_LENGTH = 0x1000000;
    static final int MAX_REDIRECTS = 5;
    private static final Map<URLFetchServicePb.URLFetchRequest.RequestMethod, MethodFactory> METHOD_FACTORY_MAP = LocalURLFetchService.buildMethodFactoryMap();
    private final HttpClient httpClient = this.initializeHttpClient();

    private static Map<URLFetchServicePb.URLFetchRequest.RequestMethod, MethodFactory> buildMethodFactoryMap() {
        HashMap<URLFetchServicePb.URLFetchRequest.RequestMethod, MethodFactory> map = new HashMap<URLFetchServicePb.URLFetchRequest.RequestMethod, MethodFactory>();
        map.put(URLFetchServicePb.URLFetchRequest.RequestMethod.GET, new MethodFactory(){

            public HttpMethodBase buildMethod(URLFetchServicePb.URLFetchRequest request) {
                return new GetMethod(request.getUrl());
            }
        });
        map.put(URLFetchServicePb.URLFetchRequest.RequestMethod.DELETE, new MethodFactory(){

            public HttpMethodBase buildMethod(URLFetchServicePb.URLFetchRequest request) {
                return new DeleteMethod(request.getUrl());
            }
        });
        map.put(URLFetchServicePb.URLFetchRequest.RequestMethod.HEAD, new MethodFactory(){

            public HttpMethodBase buildMethod(URLFetchServicePb.URLFetchRequest request) {
                return new HeadMethod(request.getUrl());
            }
        });
        map.put(URLFetchServicePb.URLFetchRequest.RequestMethod.POST, new MethodFactory(){

            public HttpMethodBase buildMethod(URLFetchServicePb.URLFetchRequest request) {
                RedirectablePostMethod post = new RedirectablePostMethod(request.getUrl());
                if (request.hasPayload()) {
                    ByteArrayRequestEntity requestEntity = new ByteArrayRequestEntity(request.getPayload().toByteArray());
                    post.setRequestEntity(requestEntity);
                }
                return post;
            }
        });
        map.put(URLFetchServicePb.URLFetchRequest.RequestMethod.PUT, new MethodFactory(){

            public HttpMethodBase buildMethod(URLFetchServicePb.URLFetchRequest request) {
                PutMethod put = new PutMethod(request.getUrl());
                if (request.hasPayload()) {
                    ByteArrayRequestEntity requestEntity = new ByteArrayRequestEntity(request.getPayload().toByteArray());
                    put.setRequestEntity(requestEntity);
                }
                return put;
            }
        });
        return map;
    }

    protected HttpClient initializeHttpClient() {
        HttpClient theClient = new HttpClient(new MultiThreadedHttpConnectionManager());
        theClient.getParams().setLongParameter("http.connection-manager.timeout", 5000L);
        theClient.getParams().setIntParameter("http.protocol.max-redirects", 6);
        return theClient;
    }

    public String getPackage() {
        return "urlfetch";
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
    }

    public void start() {
    }

    public void stop() {
    }

    public URLFetchServicePb.URLFetchResponse fetch(LocalRpcService.Status status, URLFetchServicePb.URLFetchRequest request) {
        if (status == null) {
            throw new NullPointerException("status cannot be null.");
        }
        if (request == null) {
            throw new NullPointerException("request cannot be null.");
        }
        if (!this.hasValidURL(request)) {
            throw new ApiProxy.ApplicationException(URLFetchServicePb.URLFetchServiceError.ErrorCode.INVALID_URL.getNumber(), "Invalid URL: " + request.getUrl());
        }
        MethodFactory methodFactory = METHOD_FACTORY_MAP.get(request.getMethod());
        if (methodFactory == null) {
            throw new IllegalArgumentException("Unsupported method: " + request.getMethod());
        }
        HttpMethodBase method = methodFactory.buildMethod(request);
        method.setFollowRedirects(request.getFollowRedirects());
        method.getParams().setIntParameter("http.connection.timeout", 5000);
        method.getParams().setIntParameter("http.socket.timeout", 5000);
        boolean sawContentType = false;
        for (URLFetchServicePb.URLFetchRequest.Header pbHeader : request.getHeaderList()) {
            method.addRequestHeader(this.pbHeaderToJakartaHeader(pbHeader));
            if (!pbHeader.getKey().equalsIgnoreCase("Content-Type")) continue;
            sawContentType = true;
        }
        if (!sawContentType && request.getMethod() == URLFetchServicePb.URLFetchRequest.RequestMethod.POST) {
            Header header = new Header();
            header.setName("Content-Type");
            header.setValue("application/x-www-form-urlencoded");
            method.addRequestHeader(header);
        }
        URLFetchServicePb.URLFetchResponse.Builder response = URLFetchServicePb.URLFetchResponse.newBuilder();
        try {
            byte[] responseBodyBytes = this.doPrivilegedExecute(method, response);
            if (responseBodyBytes != null) {
                if (responseBodyBytes.length > this.getMaxResponseLength()) {
                    throw new ApiProxy.ApplicationException(URLFetchServicePb.URLFetchServiceError.ErrorCode.RESPONSE_TOO_LARGE.getNumber(), "Response for URL " + request.getUrl() + " is too large.");
                }
                response.setContent(ByteString.copyFrom((byte[])this.limitLength(responseBodyBytes, response)));
            }
            this.jakartaHeadersToPbHeaders(method.getResponseHeaders(), response);
        }
        catch (SocketTimeoutException ste) {
            throw new ApiProxy.ApplicationException(URLFetchServicePb.URLFetchServiceError.ErrorCode.DEADLINE_EXCEEDED.getNumber(), "http method " + method.getName() + " against URL " + request.getUrl() + " timed out.");
        }
        catch (IOException e) {
            throw new ApiProxy.ApplicationException(URLFetchServicePb.URLFetchServiceError.ErrorCode.FETCH_ERROR.getNumber(), "Received exception executing http method " + method.getName() + " against URL " + request.getUrl() + ": " + e.getMessage());
        }
        finally {
            method.releaseConnection();
        }
        return response.build();
    }

    private byte[] doPrivilegedExecute(final HttpMethodBase method, final URLFetchServicePb.URLFetchResponse.Builder response) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws IOException {
                    int result = LocalURLFetchService.this.httpClient.executeMethod(method);
                    response.setStatusCode(result);
                    return method.getResponseBody();
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new RuntimeException(e);
        }
    }

    byte[] limitLength(byte[] responseBody, URLFetchServicePb.URLFetchResponse.Builder response) {
        if (responseBody != null && responseBody.length > 0x100000) {
            byte[] newResponseBody = new byte[0x100000];
            System.arraycopy(responseBody, 0, newResponseBody, 0, newResponseBody.length);
            responseBody = newResponseBody;
            response.setContentWasTruncated(true);
        }
        return responseBody;
    }

    boolean hasValidURL(URLFetchServicePb.URLFetchRequest request) {
        URL url;
        if (!request.hasUrl() || request.getUrl().length() == 0) {
            return false;
        }
        try {
            url = new URL(request.getUrl());
        }
        catch (MalformedURLException e) {
            return false;
        }
        return url.getProtocol().equals("http") || url.getProtocol().equals("https");
    }

    Header pbHeaderToJakartaHeader(URLFetchServicePb.URLFetchRequest.Header pbHeader) {
        Header jakartaHeader = new Header();
        jakartaHeader.setName(pbHeader.getKey());
        jakartaHeader.setValue(pbHeader.getValue());
        return jakartaHeader;
    }

    int getMaxResponseLength() {
        return 0x1000000;
    }

    void jakartaHeadersToPbHeaders(Header[] headers, URLFetchServicePb.URLFetchResponse.Builder response) {
        LinkedHashMap<String, String> newHeaders = new LinkedHashMap<String, String>(headers.length);
        for (Header header : headers) {
            String name = header.getName();
            String value = (String)newHeaders.get(name);
            value = value == null ? header.getValue() : value + ", " + header.getValue();
            newHeaders.put(name, value);
        }
        for (Map.Entry entry : newHeaders.entrySet()) {
            response.addHeader(URLFetchServicePb.URLFetchResponse.Header.newBuilder().setKey((String)entry.getKey()).setValue((String)entry.getValue()));
        }
    }

    private static class RedirectablePostMethod
    extends PostMethod {
        private boolean followRedirects;

        public RedirectablePostMethod() {
        }

        public RedirectablePostMethod(String uri) {
            super(uri);
        }

        public void setFollowRedirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
        }

        public boolean getFollowRedirects() {
            return this.followRedirects;
        }
    }

    private static interface MethodFactory {
        public HttpMethodBase buildMethod(URLFetchServicePb.URLFetchRequest var1);
    }
}

