/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AppEngineWebXml;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mortbay.xml.XmlParser;
import org.xml.sax.SAXException;

class AppEngineWebXmlProcessor {
    private static final Logger logger = Logger.getLogger(AppEngineWebXmlProcessor.class.getName());

    AppEngineWebXmlProcessor() {
    }

    public AppEngineWebXml processXml(InputStream is) {
        XmlParser.Node config = this.getTopLevelNode(is);
        AppEngineWebXml appEngineWebXml = new AppEngineWebXml();
        for (Object o : config) {
            if (!(o instanceof XmlParser.Node)) continue;
            XmlParser.Node node = (XmlParser.Node)o;
            this.processSecondLevelNode(node, appEngineWebXml);
        }
        return appEngineWebXml;
    }

    XmlParser.Node getTopLevelNode(InputStream is) {
        XmlParser xmlParser = new XmlParser();
        try {
            return xmlParser.parse(is);
        }
        catch (IOException e) {
            String msg = "Received IOException parsing the input stream.";
            logger.log(Level.SEVERE, msg, e);
            throw new AppEngineConfigException(msg, e);
        }
        catch (SAXException e) {
            String msg = "Received SAXException parsing the input stream.";
            logger.log(Level.SEVERE, msg, e);
            throw new AppEngineConfigException(msg, e);
        }
    }

    private void processSecondLevelNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        String elementName = node.getTag();
        if (elementName.equals("system-properties")) {
            this.processSystemPropertiesNode(node, appEngineWebXml);
        } else if (elementName.equals("env-variables")) {
            this.processEnvironmentVariablesNode(node, appEngineWebXml);
        } else if (elementName.equals("application")) {
            this.processApplicationNode(node, appEngineWebXml);
        } else if (elementName.equals("version")) {
            this.processVersionNode(node, appEngineWebXml);
        } else if (elementName.equals("static-files")) {
            this.processFilesetNode(node, appEngineWebXml, FileType.STATIC);
        } else if (elementName.equals("resource-files")) {
            this.processFilesetNode(node, appEngineWebXml, FileType.RESOURCE);
        } else if (elementName.equals("ssl-enabled")) {
            this.processSslEnabledNode(node, appEngineWebXml);
        } else if (elementName.equals("sessions-enabled")) {
            this.processSessionsEnabledNode(node, appEngineWebXml);
        } else {
            throw new AppEngineConfigException("Unrecognized element <" + elementName + ">");
        }
    }

    private void processApplicationNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setAppId(this.getTextNode(node));
    }

    private void processVersionNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setMajorVersionId(this.getTextNode(node));
    }

    private void processSslEnabledNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setSslEnabled(this.getBooleanValue(node));
    }

    private void processSessionsEnabledNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setSessionsEnabled(this.getBooleanValue(node));
    }

    private void processFilesetNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml, FileType type) {
        String path;
        XmlParser.Node subNode;
        Iterator nodeIter = this.getNodeIterator(node, "include");
        while (nodeIter.hasNext()) {
            subNode = (XmlParser.Node)nodeIter.next();
            path = this.trim(subNode.getAttribute("path"));
            if (type == FileType.STATIC) {
                appEngineWebXml.includeStaticPattern(path);
                continue;
            }
            appEngineWebXml.includeResourcePattern(path);
        }
        nodeIter = this.getNodeIterator(node, "exclude");
        while (nodeIter.hasNext()) {
            subNode = (XmlParser.Node)nodeIter.next();
            path = this.trim(subNode.getAttribute("path"));
            if (type == FileType.STATIC) {
                appEngineWebXml.excludeStaticPattern(path);
                continue;
            }
            appEngineWebXml.excludeResourcePattern(path);
        }
    }

    private Iterator getNodeIterator(XmlParser.Node node, String filter) {
        return node.iterator(filter);
    }

    private void processSystemPropertiesNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        Iterator nodeIter = this.getNodeIterator(node, "property");
        while (nodeIter.hasNext()) {
            XmlParser.Node subNode = (XmlParser.Node)nodeIter.next();
            String propertyName = this.trim(subNode.getAttribute("name"));
            String propertyValue = this.trim(subNode.getAttribute("value"));
            appEngineWebXml.addSystemProperty(propertyName, propertyValue);
        }
    }

    private void processEnvironmentVariablesNode(XmlParser.Node node, AppEngineWebXml appEngineWebXml) {
        Iterator nodeIter = this.getNodeIterator(node, "env-var");
        while (nodeIter.hasNext()) {
            XmlParser.Node subNode = (XmlParser.Node)nodeIter.next();
            String propertyName = this.trim(subNode.getAttribute("name"));
            String propertyValue = this.trim(subNode.getAttribute("value"));
            appEngineWebXml.addEnvironmentVariable(propertyName, propertyValue);
        }
    }

    private boolean getBooleanValue(XmlParser.Node node) {
        String value = this.getTextNode(node);
        return (value = value.trim()).equalsIgnoreCase("true") || value.equals("1");
    }

    private String getTextNode(XmlParser.Node node) {
        String value = (String)node.get(0);
        if (value == null) {
            value = "";
        }
        return value;
    }

    private String trim(String attribute) {
        return attribute == null ? null : attribute.trim();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FileType {
        STATIC,
        RESOURCE;

    }
}

