/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AppEngineConfigException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mortbay.xml.XmlParser;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfigXmlReader<T> {
    protected final String appDir;
    protected final boolean required;
    protected Logger logger;

    public AbstractConfigXmlReader(String appDir, boolean required) {
        if (appDir.length() > 0 && appDir.charAt(appDir.length() - 1) != File.separatorChar) {
            appDir = appDir + File.separatorChar;
        }
        this.appDir = appDir;
        this.required = required;
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    protected abstract String getRelativeFilename();

    protected abstract T processXml(InputStream var1);

    protected T readConfigXml() {
        T configXml;
        InputStream is = null;
        if (!this.required && !this.fileExists()) {
            return null;
        }
        try {
            is = this.getInputStream();
            configXml = this.processXml(is);
            this.logger.info("Successfully processed " + this.getFilename());
        }
        catch (Exception e) {
            String msg = "Received exception processing " + this.getFilename();
            this.logger.log(Level.SEVERE, msg, e);
            if (e instanceof AppEngineConfigException) {
                throw (AppEngineConfigException)e;
            }
            throw new AppEngineConfigException(msg, e);
        }
        finally {
            this.close(is);
        }
        return configXml;
    }

    protected boolean fileExists() {
        return new File(this.getFilename()).exists();
    }

    protected boolean generatedFileExists() {
        return this.getGeneratedFile().exists();
    }

    protected InputStream getInputStream() {
        try {
            return new FileInputStream(this.getFilename());
        }
        catch (FileNotFoundException fnfe) {
            throw new AppEngineConfigException("Could not locate " + new File(this.getFilename()).getAbsolutePath(), fnfe);
        }
    }

    protected File getGeneratedFile() {
        return null;
    }

    protected InputStream getGeneratedStream() {
        File file = this.getGeneratedFile();
        if (file == null || !file.exists()) {
            return null;
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            throw new AppEngineConfigException("can't find generated " + file.getPath());
        }
    }

    protected XmlParser createXmlParser() {
        return new XmlParser();
    }

    protected XmlParser.Node getTopLevelNode(InputStream is) {
        XmlParser xmlParser = this.createXmlParser();
        try {
            return xmlParser.parse(is);
        }
        catch (IOException e) {
            String msg = "Received IOException parsing the input stream for " + this.getFilename();
            this.logger.log(Level.SEVERE, msg, e);
            throw new AppEngineConfigException(msg, e);
        }
        catch (SAXException e) {
            String msg = "Received SAXException parsing the input stream for " + this.getFilename();
            this.logger.log(Level.SEVERE, msg, e);
            throw new AppEngineConfigException(msg, e);
        }
    }

    protected void parse(ParserCallback parseCb, InputStream is) {
        Stack<XmlParser.Node> stack = new Stack<XmlParser.Node>();
        XmlParser.Node top = this.getTopLevelNode(is);
        this.parse(top, stack, parseCb);
    }

    protected void parse(XmlParser.Node node, Stack<XmlParser.Node> stack, ParserCallback parseCb) {
        parseCb.newNode(node, stack);
        stack.push(node);
        for (Object child : node) {
            if (!(child instanceof XmlParser.Node)) continue;
            this.parse((XmlParser.Node)child, stack, parseCb);
        }
        stack.pop();
    }

    protected void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new AppEngineConfigException(e);
            }
        }
    }

    protected String getFilename() {
        return this.appDir + this.getRelativeFilename();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ParserCallback {
        public void newNode(XmlParser.Node var1, Stack<XmlParser.Node> var2);
    }
}

