/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.apphosting.utils.security.urlfetch.URLFetchServiceStreamHandler;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.HashMap;
import java.util.Map;

public class StreamHandlerFactory
implements URLStreamHandlerFactory {
    private static boolean factoryIsInstalled;
    private Map<String, URLStreamHandler> handlers = new HashMap<String, URLStreamHandler>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void install() {
        Class<StreamHandlerFactory> clazz = StreamHandlerFactory.class;
        synchronized (StreamHandlerFactory.class) {
            if (!factoryIsInstalled) {
                StreamHandlerFactory factory = new StreamHandlerFactory();
                try {
                    URL.setURLStreamHandlerFactory(factory);
                }
                catch (Error e) {
                    Object currentFactory = null;
                    try {
                        Field f = URL.class.getDeclaredField("factory");
                        f.setAccessible(true);
                        currentFactory = f.get(null);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("Failed to find the currently installed factory", ex);
                    }
                    if (currentFactory == null) {
                        throw new RuntimeException("The current factory is null, but we were unable to set a new factory", e);
                    }
                    String currentFactoryType = currentFactory.getClass().getName();
                    if (currentFactoryType.equals(StreamHandlerFactory.class.getName())) {
                        factoryIsInstalled = true;
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return;
                    }
                    throw new IllegalStateException("A factory of type " + currentFactoryType + " has already been installed");
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private StreamHandlerFactory() {
        URLFetchServiceStreamHandler httpHandler = new URLFetchServiceStreamHandler();
        this.handlers.put("http", httpHandler);
        this.handlers.put("https", httpHandler);
    }

    public URLStreamHandler createURLStreamHandler(String protocol) {
        return this.handlers.get(protocol);
    }
}

