/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.WebXml;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.io.WriterOutputStream;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.PathMap;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.resource.Resource;
import org.mortbay.util.URIUtil;

public class LocalResourceFileServlet
extends HttpServlet {
    private static final Logger logger = Logger.getLogger(LocalResourceFileServlet.class.getName());
    private static final String CACHE_CONTROL_VALUE = "private";
    private String contextPath;
    private Resource resourceBase;
    private String[] welcomeFiles;

    public void init() throws ServletException {
        ContextHandler.SContext context = (ContextHandler.SContext)this.getServletContext();
        this.contextPath = context.getContextPath();
        this.welcomeFiles = context.getContextHandler().getWelcomeFiles();
        try {
            this.resourceBase = Resource.newResource(context.getResource("/"));
        }
        catch (MalformedURLException ex) {
            logger.log(Level.WARNING, "Could not initialize:", ex);
            throw new ServletException((Throwable)ex);
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Could not initialize:", ex);
            throw new ServletException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInContext;
        String pathInfo;
        String servletPath;
        Boolean included;
        AppEngineWebXml appEngineWebXml = (AppEngineWebXml)this.getServletContext().getAttribute("com.google.appengine.tools.development.appEngineWebXml");
        WebXml webXml = (WebXml)this.getServletContext().getAttribute("com.google.appengine.tools.development.webXml");
        Boolean forwarded = (Boolean)request.getAttribute("org.mortbay.jetty.forwarded");
        if (forwarded == null) {
            forwarded = Boolean.FALSE;
        }
        if ((included = (Boolean)request.getAttribute("org.mortbay.jetty.included")) != null && included.booleanValue()) {
            servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
            pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
            if (servletPath == null) {
                servletPath = request.getServletPath();
                pathInfo = request.getPathInfo();
            }
        } else {
            included = Boolean.FALSE;
            servletPath = request.getServletPath();
            pathInfo = request.getPathInfo();
        }
        if (this.maybeServeWelcomeFile(pathInContext = URIUtil.addPaths(servletPath, pathInfo), included, forwarded, request, response)) {
            return;
        }
        Resource resource = null;
        try {
            resource = this.getResource(pathInContext);
            boolean endsWithSlash = pathInContext.endsWith("/");
            if (resource.isDirectory()) {
                if (included.booleanValue() || this.passConditionalHeaders(request, response, resource)) {
                    response.sendError(403);
                }
            } else if (resource == null || !resource.exists()) {
                logger.warning("No file found for: " + pathInContext);
                response.sendError(404);
            } else {
                boolean isStatic = appEngineWebXml.includesStatic(pathInContext);
                boolean isResource = appEngineWebXml.includesResource(pathInContext);
                boolean usesRuntime = webXml.matches(pathInContext);
                Boolean isWelcomeFile = (Boolean)request.getAttribute("com.google.appengine.tools.development.isWelcomeFile");
                if (isWelcomeFile == null) {
                    isWelcomeFile = false;
                }
                if (isStatic && usesRuntime && !included.booleanValue() && !forwarded.booleanValue()) {
                    logger.info("Would skip servlet filters when serving " + pathInContext + " as a static file.");
                } else {
                    if (!(isStatic || usesRuntime || included.booleanValue() || forwarded.booleanValue())) {
                        logger.warning("Cannot not serve " + pathInContext + " directly.  " + "You need to include it in <static-files> in your " + "appengine-web.xml.");
                        response.sendError(404);
                        return;
                    }
                    if (!isResource && !isWelcomeFile.booleanValue() && (included.booleanValue() || forwarded.booleanValue())) {
                        logger.warning("Could not serve " + pathInContext + " from a forward or " + "include.  You need to include it in <resource-files> in " + "your appengine-web.xml.");
                        response.sendError(404);
                        return;
                    }
                }
                if (included.booleanValue() || this.passConditionalHeaders(request, response, resource)) {
                    this.sendData(request, response, included, resource);
                }
            }
        }
        finally {
            if (resource != null) {
                resource.release();
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private Resource getResource(String pathInContext) {
        try {
            return this.resourceBase.addPath(pathInContext);
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Could not find: " + pathInContext, ex);
            return null;
        }
    }

    private boolean maybeServeWelcomeFile(String path, boolean included, boolean forwarded, HttpServletRequest request, HttpServletResponse response) throws MalformedURLException, IOException, ServletException {
        if (this.welcomeFiles == null) {
            return false;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        AppEngineWebXml appEngineWebXml = (AppEngineWebXml)this.getServletContext().getAttribute("com.google.appengine.tools.development.appEngineWebXml");
        ContextHandler.SContext context = (ContextHandler.SContext)this.getServletContext();
        ServletHandler handler = ((Context)context.getContextHandler()).getServletHandler();
        PathMap.Entry defaultEntry = handler.getHolderEntry("/");
        PathMap.Entry jspEntry = handler.getHolderEntry("/foo.jsp");
        for (String welcomeName : this.welcomeFiles) {
            RequestDispatcher namedDispatcher;
            String welcomePath = path + welcomeName;
            String relativePath = welcomePath.substring(1);
            PathMap.Entry entry = handler.getHolderEntry(welcomePath);
            if (entry != defaultEntry && entry != jspEntry) {
                RequestDispatcher dispatcher = request.getRequestDispatcher(path + welcomeName);
                return this.serveWelcomeFileAsForward(dispatcher, included, request, response);
            }
            Resource welcomeFile = this.getResource(path + welcomeName);
            if (welcomeFile.exists()) {
                RequestDispatcher dispatcher;
                if (appEngineWebXml.includesStatic(relativePath)) {
                    if (included || forwarded) {
                        return this.serveWelcomeFileAsRedirect(path + welcomeName, included, request, response);
                    }
                    dispatcher = request.getRequestDispatcher(path + welcomeName);
                    return this.serveWelcomeFileAsForward(dispatcher, included, request, response);
                }
                if (entry != defaultEntry) {
                    dispatcher = request.getRequestDispatcher(path + welcomeName);
                    return this.serveWelcomeFileAsForward(dispatcher, included, request, response);
                }
                if (appEngineWebXml.includesResource(relativePath)) {
                    dispatcher = request.getRequestDispatcher(path + welcomeName);
                    return this.serveWelcomeFileAsForward(dispatcher, included, request, response);
                }
            }
            if ((namedDispatcher = context.getNamedDispatcher(welcomeName)) == null) continue;
            return this.serveWelcomeFileAsForward(namedDispatcher, included, request, response);
        }
        return false;
    }

    private boolean serveWelcomeFileAsRedirect(String path, boolean included, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (included) {
            return false;
        }
        response.setContentLength(0);
        String q = request.getQueryString();
        if (q != null && q.length() != 0) {
            response.sendRedirect(path + "?" + q);
        } else {
            response.sendRedirect(path);
        }
        return true;
    }

    private boolean serveWelcomeFileAsForward(RequestDispatcher dispatcher, boolean included, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!included && !request.getRequestURI().endsWith("/")) {
            this.redirectToAddSlash(request, response);
            return true;
        }
        request.setAttribute("com.google.appengine.tools.development.isWelcomeFile", (Object)true);
        if (dispatcher != null) {
            if (included) {
                dispatcher.include((ServletRequest)request, (ServletResponse)response);
            } else {
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            }
            return true;
        }
        return false;
    }

    private void redirectToAddSlash(HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuffer buf = request.getRequestURL();
        int param = buf.lastIndexOf(";");
        if (param < 0) {
            buf.append('/');
        } else {
            buf.insert(param, '/');
        }
        String q = request.getQueryString();
        if (q != null && q.length() != 0) {
            buf.append('?');
            buf.append(q);
        }
        response.setContentLength(0);
        response.sendRedirect(response.encodeRedirectURL(buf.toString()));
    }

    private boolean passConditionalHeaders(HttpServletRequest request, HttpServletResponse response, Resource resource) throws IOException {
        if (!request.getMethod().equals("HEAD")) {
            long ifmsl;
            String ifms = request.getHeader("If-Modified-Since");
            if (ifms != null && (ifmsl = request.getDateHeader("If-Modified-Since")) != -1L && resource.lastModified() <= ifmsl) {
                response.reset();
                response.setStatus(304);
                response.flushBuffer();
                return false;
            }
            long date = request.getDateHeader("If-Unmodified-Since");
            if (date != -1L && resource.lastModified() > date) {
                response.sendError(412);
                return false;
            }
        }
        return true;
    }

    private void sendData(HttpServletRequest request, HttpServletResponse response, boolean include, Resource resource) throws IOException {
        long contentLength = resource.length();
        if (!include) {
            this.writeHeaders(response, resource, contentLength);
        }
        Object out = null;
        try {
            out = response.getOutputStream();
        }
        catch (IllegalStateException e) {
            out = new WriterOutputStream(response.getWriter());
        }
        resource.writeTo((OutputStream)out, 0L, contentLength);
    }

    private void writeHeaders(HttpServletResponse response, Resource resource, long count) throws IOException {
        String contentType = this.getServletContext().getMimeType(resource.getName());
        if (contentType != null) {
            response.setContentType(contentType);
        }
        if (count != -1L) {
            if (count < Integer.MAX_VALUE) {
                response.setContentLength((int)count);
            } else {
                response.setHeader("Content-Length", String.valueOf(count));
            }
        }
        response.setDateHeader("Last-Modified", resource.lastModified());
        response.setHeader("Cache-Control", CACHE_CONTROL_VALUE);
    }
}

