/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.development.DevAppServer;
import com.google.appengine.tools.development.DevAppServerFactory;
import com.google.appengine.tools.info.SdkInfo;
import com.google.appengine.tools.info.UpdateCheck;
import com.google.appengine.tools.util.Action;
import com.google.appengine.tools.util.Logging;
import com.google.appengine.tools.util.Option;
import com.google.appengine.tools.util.Parser;
import java.awt.Toolkit;
import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class DevAppServerMain {
    private final Action ACTION = new StartAction();
    private String server = SdkInfo.getDefaultServer();
    private String address = "127.0.0.1";
    private int port = 8080;
    private boolean disableUpdateCheck;
    private final List<Option> PARSERS = Arrays.asList(new Option("h", "help", true){

        public void apply() {
            DevAppServerMain.printHelp(System.err);
            System.exit(0);
        }
    }, new Option("s", "server", false){

        public void apply() {
            DevAppServerMain.this.server = this.getValue();
        }
    }, new Option("a", "address", false){

        public void apply() {
            DevAppServerMain.this.address = this.getValue();
        }
    }, new Option("p", "port", false){

        public void apply() {
            DevAppServerMain.this.port = Integer.valueOf(this.getValue());
        }
    }, new Option(null, "sdk_root", false){

        public void apply() {
            System.setProperty("appengine.sdk.root", this.getValue());
        }
    }, new Option(null, "disable_update_check", true){

        public void apply() {
            DevAppServerMain.this.disableUpdateCheck = true;
        }
    });

    public static void main(String[] args) throws Exception {
        Logging.initializeLogging();
        if (System.getProperty("os.name").equalsIgnoreCase("Mac OS X")) {
            Toolkit.getDefaultToolkit();
        }
        new DevAppServerMain(args);
    }

    public DevAppServerMain(String[] args) throws Exception {
        Parser parser = new Parser();
        Parser.ParseResult result = parser.parseArgs(this.ACTION, this.PARSERS, args);
        result.applyArgs();
    }

    public static void printHelp(PrintStream out) {
        out.println("Usage: <dev-appserver> [options] <war directory>");
        out.println("");
        out.println("Options:");
        out.println(" --help, -h                 Show this help message and exit.");
        out.println(" --server=SERVER            The server to use to determine the latest");
        out.println("  -s SERVER                   SDK version.");
        out.println(" --address=ADDRESS          The address of the interface on the local machine");
        out.println("  -a ADDRESS                  to bind to (or 0.0.0.0 for all interfaces).");
        out.println(" --port=PORT                The port number to bind to on the local machine.");
        out.println("  -p PORT");
        out.println(" --sdk_root=root            Overrides where the SDK is located.");
        out.println(" --disable_update_check     Disable the check for newer SDK versions.");
    }

    public static void validateWarPath(File war) {
        if (!war.exists()) {
            System.out.println("Unable to find the webapp directory " + war);
            DevAppServerMain.printHelp(System.err);
            System.exit(1);
        } else if (!war.isDirectory()) {
            System.out.println("dev_appserver only accepts webapp directories, not war files.");
            DevAppServerMain.printHelp(System.err);
            System.exit(1);
        }
    }

    class StartAction
    extends Action {
        StartAction() {
            super("start");
        }

        public void apply() {
            UpdateCheck updateCheck;
            List args = this.getArgs();
            if (args.size() != 1) {
                DevAppServerMain.printHelp(System.err);
                System.exit(1);
            }
            if ((updateCheck = new UpdateCheck(DevAppServerMain.this.server)).allowedToCheckForUpdates() && !DevAppServerMain.this.disableUpdateCheck) {
                updateCheck.maybePrintNagScreen(System.err);
            }
            try {
                File appDir = new File((String)args.get(0)).getCanonicalFile();
                DevAppServerMain.validateWarPath(appDir);
                DevAppServer server = new DevAppServerFactory().createDevAppServer(appDir, DevAppServerMain.this.address, DevAppServerMain.this.port);
                Properties properties = System.getProperties();
                server.setServiceProperties(properties);
                server.start();
                try {
                    while (true) {
                        Thread.sleep(3600000L);
                    }
                }
                catch (InterruptedException e) {
                    System.out.println("Shutting down.");
                    System.exit(0);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(1);
            }
        }
    }
}

