/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.optimizers.impl.refl.nodes;

import java.lang.reflect.Method;
import org.mvel2.CompileException;
import org.mvel2.DataConversion;
import org.mvel2.compiler.AccessorNode;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.util.ParseTools;

public class SetterAccessor
implements AccessorNode {
    private AccessorNode nextNode;
    private final Method method;
    private Class<?> targetType;
    private boolean coercionRequired = false;
    public static final Object[] EMPTY = new Object[0];

    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
        try {
            if (this.coercionRequired) {
                return this.method.invoke(ctx, DataConversion.convert(value, this.targetType));
            }
            return this.method.invoke(ctx, value);
        }
        catch (IllegalArgumentException e) {
            Method o;
            if (ctx != null && this.method.getDeclaringClass() != ctx.getClass() && (o = ParseTools.getBestCandidate(EMPTY, this.method.getName(), ctx.getClass(), ctx.getClass().getMethods(), true)) != null) {
                return this.executeOverrideTarget(o, ctx, value);
            }
            if (!this.coercionRequired) {
                this.coercionRequired = true;
                return this.setValue(ctx, elCtx, variableFactory, value);
            }
            throw new CompileException("unable to bind property", e);
        }
        catch (Exception e) {
            throw new CompileException("error binding property", e);
        }
    }

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory vars) {
        return null;
    }

    public SetterAccessor(Method method) {
        this.method = method;
        this.targetType = method.getParameterTypes()[0];
    }

    public Method getMethod() {
        return this.method;
    }

    public AccessorNode setNextNode(AccessorNode nextNode) {
        this.nextNode = nextNode;
        return this.nextNode;
    }

    public AccessorNode getNextNode() {
        return this.nextNode;
    }

    public String toString() {
        return this.method.getDeclaringClass().getName() + "." + this.method.getName();
    }

    public Class getKnownEgressType() {
        return this.method.getReturnType();
    }

    private Object executeOverrideTarget(Method o, Object ctx, Object value) {
        try {
            return o.invoke(ctx, DataConversion.convert(value, this.targetType));
        }
        catch (Exception e2) {
            throw new CompileException("unable to invoke method", e2);
        }
    }
}

