/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.t2framework.commons.exception.IORuntimeException;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CloseableUtil;

public class WriterUtil {
    public static FileWriter createFileWriter(File file) {
        Assertion.notNull(file);
        try {
            return new FileWriter(file);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static PrintWriter createPrintWriter(Writer writer) {
        Assertion.notNull(writer);
        return new PrintWriter(writer){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                Object object = this.lock;
                synchronized (object) {
                    if (this.out == null) {
                        return;
                    }
                    CloseableUtil.close(this.out);
                    this.out = null;
                }
            }
        };
    }

    public static PrintWriter createPrintWriter(File file) {
        Assertion.notNull(file);
        return WriterUtil.createPrintWriter(WriterUtil.createFileWriter(file));
    }
}

