/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.t2framework.commons.util.JarFileUtil;
import org.t2framework.commons.util.PatternUtil;
import org.t2framework.commons.util.ResourceUtil;
import org.t2framework.commons.util.Traversal;
import org.t2framework.commons.util.URLUtil;
import org.t2framework.commons.util.ZipFileUtil;

public class Traverser {
    protected String rootPackageName;
    protected Pattern[] classPatterns;
    protected Pattern[] ignorePatterns;
    protected Class<?> referenceClass;
    protected Map<String, Strategy> strategies = new HashMap<String, Strategy>();

    public Traverser(String rootPackageName, String[] classPatternStrings, String[] ignorePatternStrings, Class<?> referenceClass) {
        this.strategies.put("file", new FileSystemStrategy());
        this.strategies.put("jar", new JarFileStrategy());
        this.strategies.put("wsjar", new JarFileStrategy());
        this.strategies.put("zip", new ZipFileStrategy());
        this.strategies.put("vfszip", new ZipFileStrategy());
        this.strategies.put("code-source", new CodeSourceFileStrategy());
        this.rootPackageName = rootPackageName;
        this.classPatterns = this.toPatterns(classPatternStrings);
        this.ignorePatterns = this.toPatterns(ignorePatternStrings);
        this.referenceClass = referenceClass;
    }

    protected Pattern[] toPatterns(String[] patternStrings) {
        Pattern[] patterns = new Pattern[patternStrings.length];
        for (int i = 0; i < patternStrings.length; ++i) {
            patterns[i] = PatternUtil.getPattern(patternStrings[i]);
        }
        return patterns;
    }

    public void addStrategy(String protocol, Strategy strategy) {
        this.strategies.put(protocol, strategy);
    }

    public void clearStrategies() {
        this.strategies.clear();
    }

    public Strategy getStrategy(String protocol) {
        return this.strategies.get(URLUtil.toCanonicalProtocol(protocol));
    }

    public void traverse(Traversal.ClassHandler classHandler) {
        String baseClassPath = ResourceUtil.getResourcePath(this.referenceClass);
        URL url = ResourceUtil.getResource(baseClassPath);
        classHandler = this.wrap(classHandler);
        Strategy strategy = this.getStrategy(url.getProtocol());
        strategy.handle(this.referenceClass, url, this.rootPackageName, classHandler);
    }

    protected Traversal.ClassHandler wrap(Traversal.ClassHandler classHandler) {
        if (classHandler == null) {
            return null;
        }
        return new RegexClassHandler(classHandler);
    }

    protected static class CodeSourceFileStrategy
    implements Strategy {
        protected CodeSourceFileStrategy() {
        }

        @Override
        public void handle(Class<?> referenceClass, URL url, String rootPackageName, Traversal.ClassHandler handler) {
            JarFile jarFile = this.createJarFile(url);
            Traversal.traverseFromJarFile(jarFile, handler);
        }

        protected JarFile createJarFile(URL url) {
            URL jarUrl = URLUtil.create("jar:file:" + url.getPath());
            return JarFileUtil.toJarFile(jarUrl);
        }
    }

    protected static class ZipFileStrategy
    implements Strategy {
        protected ZipFileStrategy() {
        }

        @Override
        public void handle(Class<?> referenceClass, URL url, String rootPackageName, Traversal.ClassHandler handler) {
            JarFile jarFile = this.createJarFile(url);
            Traversal.traverseFromJarFile(jarFile, handler);
        }

        protected JarFile createJarFile(URL url) {
            String jarFileName = ZipFileUtil.toZipFilePath(url);
            return JarFileUtil.create(new File(jarFileName));
        }
    }

    protected static class JarFileStrategy
    implements Strategy {
        protected JarFileStrategy() {
        }

        @Override
        public void handle(Class<?> referenceClass, URL url, String rootPackageName, Traversal.ClassHandler handler) {
            JarFile jarFile = this.createJarFile(url);
            Traversal.traverseFromJarFile(jarFile, handler);
        }

        protected JarFile createJarFile(URL url) {
            return JarFileUtil.toJarFile(url);
        }
    }

    protected static class FileSystemStrategy
    implements Strategy {
        protected FileSystemStrategy() {
        }

        @Override
        public void handle(Class<?> referenceClass, URL url, String rootPackageName, Traversal.ClassHandler handler) {
            File rootDir = this.getRootDir(referenceClass, url);
            Traversal.traverse(rootDir, rootPackageName, handler);
        }

        protected File getRootDir(Class<?> referenceClass, URL url) {
            String[] names = referenceClass.getName().split("\\.");
            File path = ResourceUtil.getFile(url);
            for (int i = 0; i < names.length; ++i) {
                path = path.getParentFile();
            }
            return path;
        }
    }

    public static interface Strategy {
        public void handle(Class<?> var1, URL var2, String var3, Traversal.ClassHandler var4);
    }

    protected class RegexClassHandler
    implements Traversal.ClassHandler {
        protected Traversal.ClassHandler handler;

        public RegexClassHandler(Traversal.ClassHandler handler) {
            this.handler = handler;
        }

        @Override
        public void processClass(String packageName, String shortClassName) {
            if (!this.containsPackage(packageName)) {
                return;
            }
            String className = packageName.length() == Traverser.this.rootPackageName.length() ? shortClassName : packageName.substring(Traverser.this.rootPackageName.length() + 1) + shortClassName;
            if (!this.containsClass(className)) {
                return;
            }
            this.handler.processClass(packageName, shortClassName);
        }

        protected boolean containsClass(String className) {
            for (Pattern pattern : Traverser.this.ignorePatterns) {
                if (!pattern.matcher(className).matches()) continue;
                return false;
            }
            for (Pattern pattern : Traverser.this.classPatterns) {
                if (!pattern.matcher(className).matches()) continue;
                return true;
            }
            return false;
        }

        protected boolean containsPackage(String packageName) {
            return packageName.equals(Traverser.this.rootPackageName) || packageName.startsWith(Traverser.this.rootPackageName + ".");
        }
    }
}

