/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.t2framework.commons.exception.ClassNotFoundRuntimeException;
import org.t2framework.commons.exception.IllegalAccessRuntimeException;
import org.t2framework.commons.exception.InstantiationRuntimeException;
import org.t2framework.commons.exception.InvocationTargetRuntimeException;
import org.t2framework.commons.exception.NoSuchConstructorRuntimeException;
import org.t2framework.commons.exception.NoSuchFieldRuntimeException;
import org.t2framework.commons.exception.NoSuchMethodRuntimeException;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.commons.util.ReflectionExecutor;

public class Reflections {

    public static class GenericsUtil {
        public static Class<?> getParameterizedClass(Method method) {
            Type ret;
            Type type = method.getGenericReturnType();
            if (GenericsUtil.isTypeOf(type, List.class) && (ret = GenericsUtil.getTypeOfList(type)) != null) {
                return GenericsUtil.getRawClass(ret);
            }
            return null;
        }

        public static Type getTypeOfList(Type type) {
            if (!GenericsUtil.isTypeOf(type, List.class)) {
                return null;
            }
            return GenericsUtil.getGenericParameter(type, 0);
        }

        public static boolean isTypeOf(Type type, Class<?> clazz) {
            if (Class.class.isInstance(type)) {
                return clazz.isAssignableFrom((Class)Class.class.cast(type));
            }
            if (ParameterizedType.class.isInstance(type)) {
                ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(type);
                return GenericsUtil.isTypeOf(parameterizedType.getRawType(), clazz);
            }
            return false;
        }

        public static Type[] getGenericParameter(Type type) {
            if (!ParameterizedType.class.isInstance(type)) {
                return null;
            }
            return ((ParameterizedType)ParameterizedType.class.cast(type)).getActualTypeArguments();
        }

        public static Type getGenericParameter(Type type, int index) {
            if (!ParameterizedType.class.isInstance(type)) {
                return null;
            }
            Type[] genericParameter = GenericsUtil.getGenericParameter(type);
            if (genericParameter == null) {
                return null;
            }
            return genericParameter[index];
        }

        public static Class<?> getRawClass(Type type) {
            if (Class.class.isInstance(type)) {
                return (Class)Class.class.cast(type);
            }
            if (ParameterizedType.class.isInstance(type)) {
                ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(type);
                return GenericsUtil.getRawClass(parameterizedType.getRawType());
            }
            if (GenericArrayType.class.isInstance(type)) {
                GenericArrayType genericArrayType = (GenericArrayType)GenericArrayType.class.cast(type);
                Class<?> c = GenericsUtil.getRawClass(genericArrayType.getGenericComponentType());
                return Array.newInstance(c, 0).getClass();
            }
            return null;
        }
    }

    public static class MethodUtil {
        public static Method getDeclaredMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
            Assertion.notNulls(clazz, methodName);
            try {
                return clazz.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (NoSuchMethodException e) {
                throw new NoSuchMethodRuntimeException(clazz, methodName, parameterTypes, e);
            }
        }

        public static Method getDeclaredMethodNoException(Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
            Assertion.notNulls(clazz, methodName);
            try {
                return clazz.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (SecurityException e) {
                return null;
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }

        public static Method getMethodNoException(Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
            Assertion.notNulls(clazz, methodName);
            try {
                return clazz.getMethod(methodName, parameterTypes);
            }
            catch (SecurityException e) {
                return null;
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }

        public static Method getMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) {
            try {
                return clazz.getMethod(methodName, argTypes);
            }
            catch (NoSuchMethodException ex) {
                throw new NoSuchMethodRuntimeException(clazz, methodName, argTypes, ex);
            }
        }

        public static <T> T invokeWithVarargs(Method method, Object target, Object[] args) {
            Assertion.notNull(method);
            T ret = null;
            ret = !method.isVarArgs() ? (T)MethodUtil.invoke(method, target, args) : (T)MethodUtil.invoke(method, target, new Object[]{args});
            return ret;
        }

        public static <T> T invoke(Method method, Object target, Object[] args) throws InstantiationRuntimeException, IllegalAccessRuntimeException {
            Assertion.notNull(method);
            try {
                return (T)method.invoke(target, args);
            }
            catch (InvocationTargetException ex) {
                Throwable t = ex.getCause();
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new InvocationTargetRuntimeException(method, ex);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalAccessRuntimeException(method.getDeclaringClass(), method.getReturnType(), ex);
            }
        }

        public static boolean isAbstract(Method method) {
            int mod = method.getModifiers();
            return Modifier.isAbstract(mod);
        }

        public static String getSignature(String methodName, Class<?>[] argTypes) {
            StringBuffer buf = new StringBuffer(100);
            buf.append(methodName);
            buf.append("(");
            if (argTypes != null) {
                for (int i = 0; i < argTypes.length; ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    buf.append(argTypes[i].getName());
                }
            }
            buf.append(")");
            return buf.toString();
        }

        public static String getSignature(String methodName, Object[] methodArgs) {
            StringBuffer buf = new StringBuffer(100);
            buf.append(methodName);
            buf.append("(");
            if (methodArgs != null) {
                for (int i = 0; i < methodArgs.length; ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    if (methodArgs[i] != null) {
                        buf.append(methodArgs[i].getClass().getName());
                        continue;
                    }
                    buf.append("null");
                }
            }
            buf.append(")");
            return buf.toString();
        }

        public static boolean isEqualsMethod(Method method) {
            return method != null && method.getName().equals("equals") && method.getReturnType() == Boolean.TYPE && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class;
        }

        public static boolean isHashCodeMethod(Method method) {
            return method != null && method.getName().equals("hashCode") && method.getReturnType() == Integer.TYPE && method.getParameterTypes().length == 0;
        }

        public static boolean isToStringMethod(Method method) {
            return method != null && method.getName().equals("toString") && method.getReturnType() == String.class && method.getParameterTypes().length == 0;
        }
    }

    public static class FieldUtil {
        public static Object get(Field field, Object target) throws IllegalAccessRuntimeException {
            try {
                return field.get(target);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalAccessRuntimeException(field.getDeclaringClass(), field.getType(), ex);
            }
        }

        public static int getInt(Field field, Object target) throws IllegalAccessRuntimeException {
            try {
                return field.getInt(target);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalAccessRuntimeException(field.getDeclaringClass(), field.getType(), ex);
            }
        }

        public static Field getField(Class<?> clazz, String name) {
            Assertion.notNulls(clazz, name);
            try {
                return clazz.getDeclaredField(name);
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (NoSuchFieldException e) {
                throw new NoSuchFieldRuntimeException((Throwable)e, clazz, name);
            }
        }

        public static Field getFieldWithAccessible(Class<?> clazz, String name) {
            Assertion.notNulls(clazz, name);
            try {
                final Field f = clazz.getDeclaredField(name);
                ReflectionExecutor.doSafeAction(new ReflectionExecutor.ReflectionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        if (!f.isAccessible()) {
                            f.setAccessible(true);
                        }
                        return null;
                    }
                });
                return f;
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (NoSuchFieldException e) {
                throw new NoSuchFieldRuntimeException((Throwable)e, clazz, name);
            }
        }

        public static Field getFieldWithAccessibleNoException(Class<?> clazz, String name) {
            try {
                Field f = clazz.getDeclaredField(name);
                f.setAccessible(true);
                return f;
            }
            catch (Exception e) {
                return null;
            }
        }

        public static <T> Field getFieldWithAccessibleNoException(List<Class<?>> list, String name) {
            for (Class<?> c : list) {
                Field f = FieldUtil.getFieldWithAccessibleNoException(c, name);
                if (f == null) continue;
                return f;
            }
            return null;
        }

        public static void set(Field field, Object target, Object value) throws IllegalAccessRuntimeException {
            try {
                field.set(target, value);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalAccessRuntimeException(field.getDeclaringClass(), field.getType(), ex);
            }
        }
    }

    public static class ConstructorUtil {
        public static <T> boolean isDefaultConstructor(Constructor<T> constructor) {
            if (constructor == null) {
                return false;
            }
            int mod = constructor.getModifiers();
            Class<?>[] paramTypes = constructor.getParameterTypes();
            return Modifier.isPublic(mod) && paramTypes.length == 0;
        }

        public static <T> T newInstanceWithVarArgs(Constructor<T> constructor, Object[] args) throws InstantiationRuntimeException, IllegalAccessRuntimeException, InvocationTargetRuntimeException {
            if (!constructor.isVarArgs()) {
                return ConstructorUtil.newInstance(constructor, args);
            }
            return ConstructorUtil.newInstance(constructor, new Object[]{args});
        }

        public static <T> T newInstance(Constructor<T> constructor, Object[] args) throws InstantiationRuntimeException, IllegalAccessRuntimeException, InvocationTargetRuntimeException {
            Assertion.notNull(constructor, "constructor");
            try {
                return constructor.newInstance(args);
            }
            catch (InstantiationException ex) {
                throw new InstantiationRuntimeException(constructor.getDeclaringClass(), ex);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalAccessRuntimeException(constructor.getDeclaringClass(), ex);
            }
            catch (InvocationTargetException ex) {
                throw new InvocationTargetRuntimeException(constructor, ex);
            }
        }

        public static <T> boolean hasConstructor(Class<T> clazz, Class<?>[] parameterTypes) {
            try {
                Constructor<T> c = clazz.getConstructor(parameterTypes);
                return c != null;
            }
            catch (SecurityException e) {
                return false;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }

        public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?>[] argTypes) throws NoSuchConstructorRuntimeException {
            try {
                return clazz.getConstructor(argTypes);
            }
            catch (NoSuchMethodException ex) {
                throw new NoSuchConstructorRuntimeException(clazz, argTypes, ex);
            }
        }

        public static <T> Constructor<? extends T> findConstructorByParams(Class<? extends T> c, Object[] args) {
            Assertion.notNull(c);
            Assertion.notNull(args);
            block0: for (Constructor<?> ct : c.getConstructors()) {
                Class<?>[] paramTypes = ct.getParameterTypes();
                if (paramTypes.length != args.length) continue;
                for (int j = 0; j < paramTypes.length; ++j) {
                    if (!paramTypes[j].isAssignableFrom(args[j].getClass())) continue block0;
                }
                return ct;
            }
            return null;
        }
    }

    public static class ClassUtil {
        private static Map<Class<?>, Class<?>> wrapperToPrimitiveMap = CollectionsUtil.newHashMap();
        private static Map<Class<?>, Class<?>> primitiveToWrapperMap = CollectionsUtil.newHashMap();

        public static <T> Class<T> forName(String className) {
            String name = Assertion.notNull(className);
            ClassLoader loader = Assertion.notNull(Thread.currentThread().getContextClassLoader());
            return ClassUtil.forName(name, loader);
        }

        public static <T> Class<T> forName(String className, ClassLoader loader) {
            try {
                return Class.forName(className, true, loader);
            }
            catch (ClassNotFoundException e) {
                throw new ClassNotFoundRuntimeException(className, e);
            }
        }

        public static <T> Class<T> forNameNoException(String className) {
            String name = Assertion.notNull(className);
            ClassLoader loader = Assertion.notNull(Thread.currentThread().getContextClassLoader());
            return ClassUtil.forNameNoException(name, loader);
        }

        public static <T> Class<T> forNameNoException(String className, ClassLoader loader) {
            try {
                return Class.forName(className, true, loader);
            }
            catch (Throwable ignore) {
                return null;
            }
        }

        public static <T> T newInstanceByName(String className) {
            Assertion.notNull(className);
            Class<T> c = ClassUtil.forName(className);
            return ClassUtil.newInstance(c);
        }

        public static <T> T newInstanceByNameNoException(String className) {
            Class<T> clazz = ClassUtil.forNameNoException(className);
            try {
                return clazz.newInstance();
            }
            catch (Throwable ignore) {
                return null;
            }
        }

        public static <T> T newInstance(Class<T> clazz) throws InstantiationRuntimeException, IllegalAccessRuntimeException {
            try {
                return clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new InstantiationRuntimeException(clazz, e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessRuntimeException(clazz, e);
            }
        }

        public static boolean isAssignableFrom(Class from, Class to) {
            boolean fromPrimitive = from.isPrimitive();
            if (to == Object.class && !fromPrimitive) {
                return true;
            }
            boolean toPrimitive = to.isPrimitive();
            if (!fromPrimitive && toPrimitive || fromPrimitive && !toPrimitive) {
                return false;
            }
            return to.isAssignableFrom(from);
        }

        public static Class<?> toWrapperClass(Class<?> clazz) {
            Class<?> c = primitiveToWrapperMap.get(clazz);
            if (c != null) {
                return c;
            }
            return clazz;
        }

        public static String getClassName(Class<?> clazz) {
            Assertion.notNull(clazz);
            if (clazz.isArray()) {
                return clazz.getName() + "[]";
            }
            return clazz.getName();
        }

        public static String getSimpleClassName(Class<?> clazz) {
            if (clazz == null) {
                return null;
            }
            String className = ClassUtil.getClassName(clazz);
            return className.substring(className.lastIndexOf(46) + 1, className.length());
        }

        public static String getShortClassName(Class<?> clazz) {
            return ClassUtil.getShortClassName(clazz.getCanonicalName());
        }

        public static String getShortClassName(String className) {
            int i = className.lastIndexOf(46);
            if (i > 0) {
                return className.substring(i + 1);
            }
            return className;
        }

        static {
            wrapperToPrimitiveMap.put(Character.class, Character.TYPE);
            wrapperToPrimitiveMap.put(Byte.class, Byte.TYPE);
            wrapperToPrimitiveMap.put(Short.class, Short.TYPE);
            wrapperToPrimitiveMap.put(Integer.class, Integer.TYPE);
            wrapperToPrimitiveMap.put(Long.class, Long.TYPE);
            wrapperToPrimitiveMap.put(Double.class, Double.TYPE);
            wrapperToPrimitiveMap.put(Float.class, Float.TYPE);
            wrapperToPrimitiveMap.put(Boolean.class, Boolean.TYPE);
            primitiveToWrapperMap.put(Character.TYPE, Character.class);
            primitiveToWrapperMap.put(Byte.TYPE, Byte.class);
            primitiveToWrapperMap.put(Short.TYPE, Short.class);
            primitiveToWrapperMap.put(Integer.TYPE, Integer.class);
            primitiveToWrapperMap.put(Long.TYPE, Long.class);
            primitiveToWrapperMap.put(Double.TYPE, Double.class);
            primitiveToWrapperMap.put(Float.TYPE, Float.class);
            primitiveToWrapperMap.put(Boolean.TYPE, Boolean.class);
        }
    }

    public static class PackageUtil {
        private PackageUtil() {
        }

        public static String getPackageName(Class<?> c) {
            Assertion.notNull(c);
            Package p = c.getPackage();
            if (p == null) {
                String name = c.getName();
                return name.substring(0, name.lastIndexOf("."));
            }
            return p.getName();
        }

        public static boolean isJavaPackage(Class<?> c) {
            Assertion.notNull(c);
            String name = c.getName();
            return name.startsWith("java.") || name.startsWith("javax.");
        }
    }

    public static class ClassLoaderUtil {
        public static ClassLoader getClassLoader(Class<?> targetClass) {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                return contextClassLoader;
            }
            ClassLoader targetClassLoader = targetClass.getClassLoader();
            ClassLoader thisClassLoader = ClassLoaderUtil.class.getClassLoader();
            if (targetClassLoader != null && thisClassLoader != null) {
                if (ClassLoaderUtil.isAncestor(thisClassLoader, targetClassLoader)) {
                    return thisClassLoader;
                }
                return targetClassLoader;
            }
            if (targetClassLoader != null) {
                return targetClassLoader;
            }
            if (thisClassLoader != null) {
                return thisClassLoader;
            }
            ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
            if (systemClassLoader != null) {
                return systemClassLoader;
            }
            throw new IllegalStateException();
        }

        protected static boolean isAncestor(ClassLoader cl, ClassLoader other) {
            while (cl != null) {
                if (cl == other) {
                    return true;
                }
                cl = cl.getParent();
            }
            return false;
        }
    }
}

