/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import org.t2framework.commons.exception.FileNotFoundRuntimeException;
import org.t2framework.commons.exception.IORuntimeException;
import org.t2framework.commons.exception.UnsupportedEncodingRuntimeException;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CloseableUtil;

public class ReaderUtil {
    private static final int BUF_SIZE = 8192;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readText(Reader reader) {
        BufferedReader in = new BufferedReader(reader);
        StringBuilder out = new StringBuilder(100);
        try {
            try {
                int n;
                char[] buf = new char[8192];
                while ((n = in.read(buf)) >= 0) {
                    out.append(buf, 0, n);
                }
            }
            finally {
                CloseableUtil.close(in);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return out.toString();
    }

    public static BufferedReader createBufferedReader(InputStream is) {
        Assertion.notNull(is);
        return ReaderUtil.createBufferedReader(new InputStreamReader(is));
    }

    public static BufferedReader createBufferedReader(InputStream is, String charset) {
        Assertion.notNulls(is, charset);
        try {
            return ReaderUtil.createBufferedReader(new InputStreamReader(is, charset));
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedEncodingRuntimeException(charset);
        }
    }

    public static BufferedReader createBufferedReader(Reader reader) {
        Assertion.notNull(reader);
        return new BufferedReader(reader);
    }

    public static BufferedReader createBufferedReader(File file) {
        Assertion.notNull(file);
        try {
            return ReaderUtil.createBufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundRuntimeException((IOException)e, file);
        }
    }

    public static BufferedReader createBufferedReader(String value) {
        Assertion.notNull(value);
        return ReaderUtil.createBufferedReader(new StringReader(value));
    }
}

